#!/usr/bin/python

################################################################################
# This file is part of the acronym-fi package
#
# Copyright (C) 2000-2003 Marko Grnroos <magi@iki.fi>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, US
#
# See URL http://www.gnu.org/copyleft/gpl.html for full license.
################################################################################

import cgi,os,sys,re,locale
from random import *
from string import *
from webpage import *
import kieli
import sanasto

locale.setlocale (locale.LC_ALL, "")

################################################################################
# Function:    alfamappi
# Description: Builds associative maps with "LETTER" -> [LIST OF WORDS]
################################################################################
def alfamappi (lista):
    result = {}
    for item in lista:
        initial = item[0]
        if result.has_key (initial):
            result[initial] = result[initial] + [item]
        else:
            result[initial] = [item]
    return result

################################################################################
# Function: luoSanaLuokat
################################################################################
def luoSanaluokat(monikko):
    if monikko:
        adjektiivit = alfamappi (map (lambda x: kieli.taivuta(x, "monikko"), sanasto.adjektiivit))
        substantiivit = alfamappi (map (lambda x: kieli.taivuta(x, "monikko"), sanasto.substantiivit))
        verbit = alfamappi (map (lambda x: kieli.taivutaVerbi(x, "mon3"), sanasto.verbit))
    else:
        adjektiivit = alfamappi (sanasto.adjektiivit)
        substantiivit = alfamappi (sanasto.substantiivit)
        verbit = alfamappi (map (lambda x: kieli.taivutaVerbi(x, "yks3"), sanasto.verbit))
        
    komparatiivit = alfamappi (map (lambda x: kieli.taivuta(x, "komparatiivi"), sanasto.adjektiivit))
    genetiivit = alfamappi (map (lambda x: kieli.taivuta(x, "genetiivi"), sanasto.adjektiivit))

    sanaluokat = {
        'A': adjektiivit,
        'S': substantiivit,
        'V': verbit,
        'K': komparatiivit,
        'G': genetiivit
        }

    return sanaluokat

################################################################################
# Define rewriting grammar
################################################################################
grammar = [
    ["S0", ["A0 S1", "S1 joka V0"]],
    ["A0 S1", ["A0 S2 joka V0"]],
    ["A3 S1", ["A0 S2 joka V0"]],
    ["S1 joka", ["A0 S2 joka"]],
    ["A0", ["A1 ja A2"]],
    ["A1", ["A1, A1"]],
    ["A1", ["G1 A3"]],
    ["A2", ["G1 A3"]],
    ["V0", ["V1 ja V2"]],
    ["V1", ["V1, V1"]],
    ["V1", ["V1 K0"]],
    ["K0", ["G1 K1"]]
    ]

# Terminal symbols
terminaalit = [
    ["A1", "A"],
    ["A2", "A"],
    ["A3", "A"],
    ["A0", "A"],
    ["S2", "S"],
    ["S1", "S"],
    ["S0", "S"],
    ["S", "S"],
    ["V1", "V"],
    ["V2", "V"],
    ["V0", "V"],
    ["V", "V"],
    ["K0 K0 K0", "K, K ja K"],
    ["K0 K0", "K ja K"],
    ["K1", "K"],
    ["K0", "K"],
    ["G1", "G"],
    ]

################################################################################
################################################################################

def satunnainen (sanat, merkki):
    return sanat[merkki][0]

def generateRandom (result):
    notFound = 1
    while notFound:
        rule = grammar[randrange(len(grammar))]
        LHS = rule[0]
        RHS = rule[1][randrange(len(rule[1]))]
        if re.search (LHS, result):
            print "<TR><TD>%s -> %s</TD>" % (LHS, RHS),
            result = re.sub (LHS, RHS, result, 1)
            print "\t\t<TD>\"" + result + "\"</TD></TR>"
            notFound = 0
    return result

################################################################################
# Function:    akronymisoi
# Description: 
################################################################################
def akronymisoi (sana, monikko):
    rakenne = "S0"
    print "<TABLE ALIGN=center>"
    print "<TR><TD></TD><TD>\"" + rakenne + "\"</TD></TR>"

    # Generoi rakenne
    for i in xrange (len(sana)-1):
        rakenne = generateRandom (rakenne)

    # Knn terminaalit
    for tPari in terminaalit:
        rakenne = re.sub (tPari[0], tPari[1], rakenne)

    print "</TABLE><P>"
    print "Rakenne: %s <P>" % rakenne

    sanaluokat = luoSanaluokat (monikko)

    # Korvaa sanaluokittain
    result = ""
    s = 0
    for i in xrange(len(rakenne)):
        merkki = rakenne[i]
        if merkki in uppercase:
            syotemerkki = sana[s]
            s = s + 1
            sanat = sanaluokat[merkki][syotemerkki]
            korvaava = sanat[randrange(len(sanat))]

            # Uppercase first letter
            korvaava = upper(korvaava[0]) + korvaava[1:]
            result = result + korvaava
        else:
            result = result + merkki

    # "joka" -> "jotka"
    if monikko:
        result = re.sub (r' joka ', ' jotka ', result)

    return result

################################################################################
# Main
################################################################################

def iff(ehto,tosi,epatosi):
    if ehto:
        return tosi
    else:
        return epatosi

def tulosta():

    params = cgi.FieldStorage()

    header ("Akronyymigeneraattori")

    if params.has_key ("sana"):
        sana = lower(params["sana"].value)
        print "Sana: %s <P>" % sana
        upsana = upper(sana)
        upsana = re.sub(r'(.)', r'\1.', upsana)
        monikko = atoi (params["monikko"].value)
        print "<H3>%s: %s</H3>"  % (upsana, akronymisoi (sana, monikko))
    else:
        sana = ""
        monikko = 0

    print "<FORM ACTION='akronyymi.cgi' METHOD=GET>"
    print "Kirjoita sana thn: <INPUT TYPE=text NAME='sana' VALUE='%s'>" % sana
    print "<INPUT TYPE=submit VALUE='Tee'>"
    print "<SELECT NAME=monikko>"
    print "<OPTION VALUE='0' %s>Yksikk</OPTION>" % iff (monikko, "", "SELECTED")
    print "<OPTION VALUE='1' %s>Monikko</OPTION>" % iff (monikko, "SELECTED", "")
    print "</SELECT>"
    print "</FORM><P>"
    print "<B>Huom.</B> Sanassa ei saa olla erikoismerkkej, vlilyntej eik numeroita. Eli vain pieni kirjaimia a-.<P>"
    print "Ohjelma on ''kehitteill'', eik toimi ihan aina eik aivan oikein.<P>"

    footer ()
