#!/usr/bin/python

################################################################################
# This file is part of the acronym-fi package
#
# Copyright (C) 2000-2003 Marko Grnroos <magi@iki.fi>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, US
#
# See URL http://www.gnu.org/copyleft/gpl.html for full license.
################################################################################

import re,string,os,sys

vokaalit = "[aeiouy]"
konsonantit = "[bcdfghjklmnpqrstvwxz]"

diftongit = [
    "ai", "ei", "oi", "ui", "yi", "i", "i", # i-loppuiset
    "au", "eu", "iu", "ou", # u-loppuiset
    "y", "y", "ey", "iy", # y-loppuiset
    "ie", "uo", "y" # muut
    ]


###############################################################################
##                  -----                                                    ##
##                    |    ___               |         ____                  ##
##                    |    ___| |   | |   | -+- |   | (                      ##
##                    |   (   |  \ /  |   |  |  |   |  \__                   ##
##                    |    \__|   V    \__!   \  \__! ____)                  ##
###############################################################################

def tavuta(sana):
    "Tavuttaa suomenkielisen sanan, palauttaen tavulistan."
    tulos = []
    tavu = ""
    for i in xrange(len(sana)):
        if i>0:
            # 1. Psnt: jokaisen konsonantti+vokaali -parin edell
            # 2. Vokaalien vliss, jotka eivt muodosta pitk vokaalia eivtk diftongia.
            if re.match (r'%s%s' % (konsonantit, vokaalit), sana[i:i+2]) \
               or (re.match (r'%s%s' % (vokaalit, vokaalit), sana[i-1:i+1]) \
                   and sana[i-1]!=sana[i] and (not sana[i-1:i+1] in diftongit or sana[i-2]==sana[i-1])):
                tulos = tulos + [tavu]
                tavu = ""
        tavu = tavu + sana[i]
    tulos = tulos + [tavu]
    return tulos


###############################################################################
##                                                                           ##
##                        |   |                 o                            ##
##                        |   |  ___      |        |                         ##
##                        |   | /   ) |/\ |---  | -+-                        ##
##                         \ /  |---  |   |   ) |  |                         ##
##                          V    \__  |   |__/  |   \                        ##
##                                                                           ##
###############################################################################

def kaksivartaloinenverbi(vokaalivartalo):
    "Kertoo onko verbi kaksivartaloinen, eli onko sill mys konsonanttivartalo."
    tavuja = len(tavuta(vokaalivartalo))
    if (tavuja==2 or tavuja==3) and (vokaalivartalo[-2:]=="aa" or vokaalivartalo[-2:]=="va"):
        return 1
    elif tavuja==2 and vokaalivartalo[-1:]=="e":
        return 1
    elif tavuja>2 and vokaalivartalo[-1:]=="e":
        return 1 # Hmm, tm on outo
    return 0

def vokaalivartalo(verbi):
    "Palauttaa verbin vokaalivartalon."
    juuri = verbi
    paatepoistot = [
        [r'della$', r'tele'],
        [r'(%s)%s$'%(vokaalit,vokaalit), r'\1'],
        [r'(%s)t$'%konsonantit, r'\1\1'],
        [r'lata$', r'laa'],
        [r'(%s)ata$'%konsonantit, r'\1\1aa'],
        [r'aata$', r'akaa'],
        [r'ata$', r'aa'],
        [r'(%s)ta$'%vokaalit, r'\1a'],
        [r'(%s)ta$'%konsonantit, r'\1e'],
        [r'ta$|da$|d$', r''],
        [r't$|la$|l$', r'e'],
        [r'', r''],
         ]
    for t in paatepoistot:
        if re.search (t[0], verbi):
            juuri = re.sub (t[0], t[1], verbi)
            break
    return juuri

def aamuoto(sana):
    return re.search(r'[ao]', sana)

def taivutaVerbi(verbi, tapa):
    vartalo = vokaalivartalo(verbi)
    suffiksi = ""
    if tapa=="yks3":
        if not (vartalo[-2:] in diftongit or vartalo[-2]==vartalo[-1]):
            suffiksi = vartalo[-1]
    elif tapa=="mon3":
        if aamuoto(vartalo):
            suffiksi = "vat"
        else:
            suffiksi = "vt"
    tulos = vartalo+suffiksi
    return tulos


##############################################################################
##                      |   |            o       o                          ##
##                      |\  |                _      |                       ##
##                      | \ |  __  |/|/| | |/ \  | -+-                      ##
##                      |  \| /  \ | | | | |   | |  |                       ##
##                      |   | \__/ | | | | |   | |   \                      ##
##############################################################################

sijamuodot = [
    ["nominatiivi", ""],
    ["genetiivi", "n"],
    ["akkusatiivi", "n"],
    ["partitiivi", "a"],
    ["essiivi", "na"],
    ["translatiivi", "ksi"],
    ["inessiivi", "ssa"], # Paikallissijat
    ["elatiivi", "sta"],
    ["illatiivi", "on"],
    ["adessiivi", "lla"],
    ["ablatiivi", "lta"],
    ["allatiivi", "lle"],
    ["abessiivi", "tta"],
    ["komitatiivi", "nsa"],
    ["instruktiivi", "---"],
    ["komparatiivi", "sti"],
    ["monikko", "t"]
    ]

sijat_map = {}
for sija in sijamuodot:
    sijat_map [sija[0]] = sija[1]

sijataivutukset = [
    [r'nen$', r'se'],
    [r'tis$', r'ttii'],
    [r'ton$', r'ttoma'],
    [r'tn$', r'ttm'],
    [r'pan$', r'ppama'],
    [r'nyt$', r'nee'],
    [r'nut$', r'nee'],
    [r'eer$', r'eeri'],
    [r'ies$', r'iehe'],
    [r'mus$', r'mukse'],
    [r'hus$', r'hukse'],
    [r'tus$', r'tukse'],
    [r'nto$', r'nno'],
    [r'(%s)\1([ia])$'%(konsonantit), r'\1\2'],
    [r'(%s%s%s)$'%(konsonantit,konsonantit,vokaalit), r'\1'],
    [r'k(%s)s$'%vokaalit, r'kk\1\1'],
    [r'p(%s)s$'%vokaalit, r'pp\1\1'],
    [r'(%s)s$'%vokaalit, r'\1\1'],
    [r't(%s)$'%vokaalit, r'd\1'],
    [r'(%s)$'%vokaalit, r'\1']
    ]

#    [r'nha$', r'nha'], # pid
#    [r'ssi$', r'ssi'], # pid
#    [r'nni$', r'nni'], # pid
#    [r'mma$', r'mma'], # pid
#    [r'lli$', r'lli'], # pid
#    [r'lla$', r'lla'], # pid
#    [r'sti$', r'sti'], # pid
#    [r'ska$', r'ska'], # pid
#    [r'lle$', r'lle'], # pid
#    [r'rfi$', r'rfi'], # pid
################################################################################

def juuri(nomini):
    juuri = re.sub (r's$', '', nomini)
    return juuri

def loppuaa(sana):
    if not re.search (r'[aou]', sana[:-1]):
        return re.sub (r'a$', '', sana)
    else:
        return sana

def taivuta (nomini, sijamuoto):
    njuuri = juuri (nomini)
    
    suffiksi = sijat_map[sijamuoto]
    taivutus = nomini
    for t in sijataivutukset:
        if re.search (t[0], nomini):
            taivutus = re.sub (t[0], t[1]+suffiksi, nomini)
            break
    return loppuaa (taivutus)

################################################################################

#for sana in adjektiivit:
#    print sana + ", " + taivuta (sana, "komparatiivi")
