/**
 * $Author: magi $ $Date: 2000/01/30 22:20:38 $ $Revision: 1.1 $
 *
 * $Log: wwbase.cc,v $
 * Revision 1.1  2000/01/30 22:20:38  magi
 * added wwbase.cc for WWObject handling
 *
 **/

#include "wwbase.h"
#include "wwworld.h"



///////////////////////////////////////////////////////////////////////////////
//                |   | |   |  ___          o                                //
//                | | | | | | |   | |          ___   ___   |                 //
//                | | | | | | |   | |---    | /   ) |   \ -+-                //
//                | | | | | | |   | |   )   | |---  |      |                 //
//                 V V   V V  `___ |__/  \_|  \__   \__/   \                //
///////////////////////////////////////////////////////////////////////////////

WWWorld& WWObject::world () {
	return mpContainer->world();
}



//////////////////////////////////////////////////////////////////////////////
// |   | |   |  ___          o                  ----                        //
// | | | | | | |   | |          ___   ___   |  (      --   ___   ___   ___  //
// | | | | | | |   | |---    | /   ) |   \ -+-  ---  |  )  ___| |   \ /   ) //
// | | | | | | |   | |   )   | |---  |      |      ) |--  (   | |     |---  //
//  V V   V V  `___ |__/  \_|  \__   \__/   \ ___/  |     \__|  \__/  \__  //
//////////////////////////////////////////////////////////////////////////////

WWObjectSpace::WWObjectSpace () : mpWorld (NULL) {
	mObjects.make (1024);
}
	
int WWObjectSpace::add (WWObject* object) {
	object->mpContainer = this;

	// Put only players in the beginning (16 first slots) of the id
	// space
	int base=16;
	if (dynamic_cast<WWPlayer*>(object))
		base=0;
	
	// Look for an empty object slot
	for (int i=base; i<mObjects.size; i++)
		if (mObjects.getp(i)==NULL) {
			// An empty slot was found, put the object there
			mObjects.put (object, i);
			object->setId (i);
			return i;
		}

	// No empty slot was found -> create a new one
	mObjects.add (object);
	object->setId (mObjects.size-1);
	return mObjects.size-1;
}

/*virtual*/ void WWObjectSpace::remove (int objectId) {
	// Remove depending objects recursively
	for (int i=0; i<mObjects.size; i++)
		if (WWObject* o = mObjects.getp(i))
			if (o->owner() && o->owner()->id() == objectId)
				remove (i);

	// Remove the object itself
	mObjects.remove (objectId);
}

void WWObjectSpace::executeObjects () {
	// For every object
	for (int u=0; u<mObjects.size; u++)
		if (WWObject* object = mObjects.getp(u)) {
			try {
				// Execute any commands the object might be pending
				object->execute ();
			} catch (Exception& e) {
				fprintf (stderr, "Exception while executing object %d\n", u);
				throw;
			}
		}
}
