#include "wwformation.h"
#include "wwunit.h"



///////////////////////////////////////////////////////////////////////////////
//          |   | |   | -----                          o                     //
//          | | | | | | |                     ___   |           _            //
//          | | | | | | |---   __  |/\ |/|/|  ___| -+- |  __  |/ \           //
//          | | | | | | |     /  \ |   | | | (   |  |  | /  \ |   |          //
//           V V   V V  |     \__/ |   | | |  \__|   \ | \__/ |   |          //
///////////////////////////////////////////////////////////////////////////////

/*virtual*/ PackArray<WWCoord> WWKeepFormation::form (const RefArray<WWUnitInst>& units, const WWCoord& center, Radian facing) const return result {
	result.make (units.size);
	
	// Calculate current centerpoint.
	WWCoord curCenter (0,0);
	for (int i=0; i<units.size; i++)
		curCenter += units[i].location ();
	curCenter.x /= units.size;
	curCenter.y /= units.size;

	// Make transformation
	for (int i=0; i<units.size; i++) {
		// Calculate polar coordinates for the unit in relation to the centerpoint
		double dir = curCenter.direction (units[i].location());
		double dist = curCenter.distance (units[i].location());

		result[i].x = center.x + dist * cos (dir+facing);
		result[i].y = center.y + dist * sin (dir+facing);
	}
}



///////////////////////////////////////////////////////////////////////////////
//     |   | |   | -----                          o            | o           //
//     | | | | | | |                     ___   |           _   |   |         //
//     | | | | | | |---   __  |/\ |/|/|  ___| -+- |  __  |/ \  | | |---      //
//     | | | | | | |     /  \ |   | | | (   |  |  | /  \ |   | | | |   )     //
//      V V   V V  |     \__/ |   | | |  \__|   \ | \__/ |   | | | |__/      //
///////////////////////////////////////////////////////////////////////////////

WWFormationLib::WWFormationLib () {
	mFormations.add (new WWKeepFormation ());
}
