#ifndef __WWFORMATION_H__
#define __WWFORMATION_H__

#include <magic/map.h>
#include <magic/refarray.h>
#include <magic/packarray.h>
#include "wwbase.h"

class WWUnitInst; // In wwunit.h



///////////////////////////////////////////////////////////////////////////////
//          |   | |   | -----                          o                     //
//          | | | | | | |                     ___   |           _            //
//          | | | | | | |---   __  |/\ |/|/|  ___| -+- |  __  |/ \           //
//          | | | | | | |     /  \ |   | | | (   |  |  | /  \ |   |          //
//           V V   V V  |     \__/ |   | | |  \__|   \ | \__/ |   |          //
///////////////////////////////////////////////////////////////////////////////

/** Abstract base class for unit formations. */
class WWFormation : public Object {
  public:
								WWFormation	() {}

	/** Returns a coordinate pattern calculated for the given units.
	 *
	 *  @param center Desired center coordinates of the formation.
	 *  @param facing Facing direction of the formation, in radians.
	 **/
	virtual PackArray<WWCoord>	form				(const RefArray<WWUnitInst>& units,
													 const WWCoord& center,
													 Radian facing) const {MUST_OVERLOAD}
};

/** Formation where the units are as they were originally. Simply
 *  makes a coordinate translation and rotation.
 **/
class WWKeepFormation : public WWFormation {
  public:
	virtual PackArray<WWCoord>	form				(const RefArray<WWUnitInst>& units,
													 const WWCoord& center,
													 Radian facing) const;
};

/** Formation where the units are in lines. The length of line and
 *  separation are given as parameters.
 **/
class WWRowFormation : public WWFormation {
};

/** Formation where the units are packed together as strongly as possible.
 **/
class WWPackedFormation : public WWFormation {
};

/** Formation where the units are scattered loosely.
 **/
class WWScatteredFormation : public WWFormation {
};



///////////////////////////////////////////////////////////////////////////////
//     |   | |   | -----                          o            | o           //
//     | | | | | | |                     ___   |           _   |   |         //
//     | | | | | | |---   __  |/\ |/|/|  ___| -+- |  __  |/ \  | | |---      //
//     | | | | | | |     /  \ |   | | | (   |  |  | /  \ |   | | | |   )     //
//      V V   V V  |     \__/ |   | | |  \__|   \ | \__/ |   | | | |__/      //
///////////////////////////////////////////////////////////////////////////////

/** Collection of unit formation methods. Might be useful as a static,
 *  global object, as it really doesn't contain any data, but just
 *  method objects.
 **/
class WWFormationLib {
  public:
							WWFormationLib	();
	
	const WWFormation&	formation		(int i) const {return mFormations[i];}
	int					formations		() const {return mFormations.size;}
	
  protected:
	Array<WWFormation>	mFormations;
};

#endif
