/**
 * $Author: magi $ $Date: 2000/01/30 22:20:38 $ $Revision: 1.9 $
 *
 * $Log: wwmap.cc,v $
 * Revision 1.9  2000/01/30 22:20:38  magi
 * added wwbase.cc for WWObject handling
 *
 * Revision 1.8  2000/01/08 00:50:21  magi
 * Client connect/disconnect works. BUILD works, MOVE works partially.
 *
 * Revision 1.7  2000/01/04 11:28:31  magi
 * *** empty log message ***
 *
 **/

#include <stdio.h>
#include "wwmap.h"

WWTerrainType wwttPlain ("plain", ' ', 1.0);
Array<WWTerrainType> WWTerrainLib::sTerrainTypes;

// These two arounds (for WWCoord and WWCoordInt are actually
// identical duplicates)
const int WWCoord::around_x[8] = {0,1,1,1,0,-1,-1,-1};
const int WWCoord::around_y[8] = {1,1,0,-1,-1,-1,0,1};
const int WWCoordInt::around_x[8] = {0,1,1,1,0,-1,-1,-1};
const int WWCoordInt::around_y[8] = {1,1,0,-1,-1,-1,0,1};

//////////////////////////////////////////////////////////////////////////////
//   |   | |   | -----                     o       -----                    //
//   | | | | | |   |    ___           ___      _     |          --   ___    //
//   | | | | | |   |   /   ) |/\ |/\  ___| | |/ \    |   \   | |  ) /   )   //
//   | | | | | |   |   |---  |   |   (   | | |   |   |    \  | |--  |---    //
//    V V   V V    |    \__  |   |    \__| | |   |   |     \_/ |     \__    //
//                                                        \_/               //
//////////////////////////////////////////////////////////////////////////////

WWTerrainType::WWTerrainType (const String& name, char typeId, double moveMul)
		: mName (name), mTypeId (typeId), mMoveMul (moveMul) {
}


///////////////////////////////////////////////////////////////////////////////
//        |   | |   | -----                     o       |     o              //
//        | | | | | |   |    ___           ___      _   |       |            //
//        | | | | | |   |   /   ) |/\ |/\  ___| | |/ \  |     | |---         //
//        | | | | | |   |   |---  |   |   (   | | |   | |     | |   )        //
//         V V   V V    |    \__  |   |    \__| | |   | |____ | |__/         //
///////////////////////////////////////////////////////////////////////////////

void WWTerrainLib::add (WWTerrainType* ttype) {
	sTerrainTypes.add (ttype);
}


//////////////////////////////////////////////////////////////////////////////
//                       |   | |   | |   |                                  //
//                       | | | | | | |\ /|  ___   --                        //
//                       | | | | | | | V |  ___| |  )                       //
//                       | | | | | | | | | (   | |--                        //
//                        V V   V V  |   |  \__| |                          //
//////////////////////////////////////////////////////////////////////////////

void WWMap::make (int x, int y) {
	mGrid.make (x, y);
	rrandomize ();
}

void WWMap::rrandomize () {
	/** The map is always empty.
	 **/
	for (int i=0; i<mGrid.rows; i++)	
		for (int j=0; j<mGrid.cols; j++)
			mGrid.get (i,j) = wwttPlain;

	int a=1;
}
