/**
 * $Author: magi $ $Date: 2000/01/30 22:20:38 $ $Revision: 1.11 $
 *
 * $Log: wwmap.h,v $
 * Revision 1.11  2000/01/30 22:20:38  magi
 * added wwbase.cc for WWObject handling
 *
 * Revision 1.10  2000/01/08 00:50:21  magi
 * Client connect/disconnect works. BUILD works, MOVE works partially.
 *
 * Revision 1.9  2000/01/04 11:28:31  magi
 * *** empty log message ***
 *
 * Revision 1.8  1999/11/19 05:14:59  magi
 * *** empty log message ***
 *
 * Revision 1.7  1999/11/18 20:37:49  magi
 * wwserverin nollarunko kntyy
 **/

#ifndef __WWMAP_H__
#define __WWMAP_H__

#include <magic/pararr.h>
#include <magic/table.h>

#include "wwbase.h"
#include "wwunit.h"



//////////////////////////////////////////////////////////////////////////////
//   |   | |   | -----                     o       -----                    //
//   | | | | | |   |    ___           ___      _     |          --   ___    //
//   | | | | | |   |   /   ) |/\ |/\  ___| | |/ \    |   \   | |  ) /   )   //
//   | | | | | |   |   |---  |   |   (   | | |   |   |    \  | |--  |---    //
//    V V   V V    |    \__  |   |    \__| | |   |   |     \_/ |     \__    //
//                                                        \_/               //
//////////////////////////////////////////////////////////////////////////////

/** TerrainType is accessed by a simple ID.
 **/
class WWTerrainType {
  public:
						WWTerrainType	() {FORBIDDEN}
						WWTerrainType	(const String& name, char typeId, double moveMul);
						WWTerrainType	(const WWTerrainType& o) {}

	/** Returns a type identifier of the terrain. */
	char				typeId			() const {return mTypeId;}

	/** Returns a textual name of the terrain. */
	virtual string		name 			() const {return "(none)";}

	/** Returns a movement multiplier of the terrain. For "plain"
     *  terrain this is 1.0, for others it is usually smaller (for
     *  "roads" or something it might be larger).
	 **/
	double				moveMul			() const {return mMoveMul;}

  protected:
	double	mMoveMul;
	string	mName;
	char	mTypeId;
};

extern WWTerrainType	wwttPlain;

///////////////////////////////////////////////////////////////////////////////
//        |   | |   | -----                     o       |     o              //
//        | | | | | |   |    ___           ___      _   |       |            //
//        | | | | | |   |   /   ) |/\ |/\  ___| | |/ \  |     | |---         //
//        | | | | | |   |   |---  |   |   (   | | |   | |     | |   )        //
//         V V   V V    |    \__  |   |    \__| | |   | |____ | |__/         //
///////////////////////////////////////////////////////////////////////////////

/** Contains all the terrain types. (Not in use)
 **/
class WWTerrainLib {
  public:
	const WWTerrainType&	operator[]	(char ttype) {return sTerrainTypes[ttype];}
	void					add			(WWTerrainType* ttype);
	int						size		() const {return sTerrainTypes.size;}
  protected:
	static Array<WWTerrainType>	sTerrainTypes;
};



///////////////////////////////////////////////////////////////////////////////
//       |   | |   | |   |             ----                                  //
//       | | | | | | |\ /|  ___   --  (                 ___       ___        //
//       | | | | | | | V |  ___| |  )  ---   __  |   |  ___| |/\ /   )       //
//       | | | | | | | | | (   | |--      ) /  \ |   | (   | |   |---        //
//        V V   V V  |   |  \__| |    ___/  \__|  \__!  \__| |    \__        //
//                                             |                             //
///////////////////////////////////////////////////////////////////////////////

/** Map squares contain a simple terrain type ID.
 **/
class WWMapSquare : public Object {
  public:

	/** Sets the map square to the given value. */
							operator=		 (const WWTerrainType& tt) {mpType=&tt;}

	/** Returns the terrain type at the location. */
	const WWTerrainType&	terrainType		() const {return *mpType;}

	/** Sets a reference to a construction object located at the square.
	 **/
	void					setUnit			(WWUnitInst* c) {mpUnit=c;}

	/** Returns the unit located at the square, or NULL if no unit is
	 *  located there.
	 **/
	WWUnitInst*				unit			() const {return mpUnit;}

	/** Dummy; needed by PackTable<>. */
	//DumpContext & 			operator<<		(DumpContext& out) const {return out;}
	
  protected:
	const WWTerrainType*	mpType;

	/** Construction located at the position. */
	WWUnitInst*				mpUnit;
};



//////////////////////////////////////////////////////////////////////////////
//                       |   | |   | |   |                                  //
//                       | | | | | | |\ /|  ___   --                        //
//                       | | | | | | | V |  ___| |  )                       //
//                       | | | | | | | | | (   | |--                        //
//                        V V   V V  |   |  \__| |                          //
//////////////////////////////////////////////////////////////////////////////

/** The map is simply an n*m array of terrain plots.
 **/
class WWMap {
  public:
	
							WWMap		() {}

	/** Creates a map with given dimensions. */
	void					make		(int x, int y);

	/** Returns the terrain square for given coordinates.
	 *
	 *  The real-valued coordinates are rounded, not truncated. Thus,
	 *  a * whole number such as (4.0,6.0) refers to the center of a *
	 *  terrain square, while a half value such as (4.5,6.0) would *
	 *  refer to the crossing point between two map squares.
	 **/
	WWMapSquare&			getTerrain	(const WWCoord& pos) {
		return mGrid.get(int(pos.y), int(pos.x));
	}

	/** Random landscape on the map (very trivial). */
	void					rrandomize	();

	int						sizex		() const {return mGrid.cols;}
	int						sizey		() const {return mGrid.rows;}
	
  protected:
	PackTable<WWMapSquare> mGrid;
};

#endif
