/**
 * $Author: magi $ $Date: 2000/01/30 22:20:38 $ $Revision: 1.2 $
 *
 * $Log: wwplayer.h,v $
 * Revision 1.2  2000/01/30 22:20:38  magi
 * added wwbase.cc for WWObject handling
 *
 * Revision 1.1  2000/01/29 03:26:00  magi
 * wwplayer.h separated from wwworld.h
 *
 * Revision 1.7  2000/01/08 00:50:22  magi
 * Client connect/disconnect works. BUILD works, MOVE works partially.
 **/

#ifndef __WWPLAYER_H__
#define __WWPLAYER_H__

#include <magic/packarray.h>
#include "wwbase.h"
#include "wwmap.h"
#include "wwunit.h"

class WWWorld;



///////////////////////////////////////////////////////////////////////////////
//                 |   | |   | ----  |                                       //
//                 | | | | | | |   ) |  ___         ___                      //
//                 | | | | | | |---  |  ___| \   | /   ) |/\                 //
//                 | | | | | | |     | (   |  \  | |---  |                   //
//                  V V   V V  |     |  \__|   \_/  \__  |                   //
//                                            \_/                            //
///////////////////////////////////////////////////////////////////////////////

/** A player object.
 **/
class WWPlayer : public WWObject {
  public:
	/** The default constructor. */
								WWPlayer		();

	virtual						~WWPlayer		();

	/** Sets player's nickname. */
	void						setName			(const String& name) {mName=name;}
	
	/** Returns player's nickname. */
	const String&				name			() const {return mName;}

	/** Adds or removes resources to the player by given amount.
	 *
	 *  Returns true if resources < 0.0 after the reduction.
	 **/
	virtual bool				changeRes		(double amount);

	/** Returns the amount of stored building resources. */
	double						resources		() const {return mResources;}

	void						aimAt			(const WWCoord& at) {mAimAt = at;}
	const WWCoord&				aim				() const {return mAimAt;}
	void						select			(const PackArray<int>& selection) {mSelection = selection;}
	const PackArray<int>&		selection		() const {return mSelection;}
	virtual void				execute			() {/*dummy*/}

	/** Tells the player that one of its units has been damaged by something. */
	virtual void				unitHit			(WWUnitInst& unit) {}
	
	int							kills			() const {return mKills;}
	void						addKill			() {mKills++;}
	int							deaths			() const {return mDeaths;}
	void						addDeath		() {mDeaths++;}

  protected:
	String					mName;		/* Player's nickname. */
	double					mResources;	/* We use a single building resource. This is it. */
	WWCoord					mAimAt;		/* Current aiming coordinates. */
	PackArray<int>			mSelection;	/* Units currently selected for giving commands. */
	int						mKills;		/* Units killed by the player. */
	int						mDeaths;	/* Units killed from the player. */
};


#endif
