/**
 * $Author: magi $ $Date: 2000/01/30 22:20:39 $ $Revision: 1.4 $
 *
 * $Log: wwunit.cc,v $
 * Revision 1.4  2000/01/30 22:20:39  magi
 * added wwbase.cc for WWObject handling
 *
 * Revision 1.3  2000/01/08 00:50:21  magi
 * Client connect/disconnect works. BUILD works, MOVE works partially.
 *
 * Revision 1.2  2000/01/04 11:28:31  magi
 * *** empty log message ***
 *
 * Revision 1.1  1999/11/13 17:32:51  magi
 * Listty paljon uusia tiedostoja wwlibiin
 *
 **/

#include "wwunit.h"
#include "wwworld.h"

#include <magic/Math.h>

WWUnitLib	WWUnitLib::gUnitLib;



///////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////
//        |   |                              ___  |                          //
//        | | |  ___   ___   --         _   /   \ |  ___   ____  ____        //
//        | | | /   )  ___| |  )  __  |/ \  |     |  ___| (     (            //
//        | | | |---  (   | |--  /  \ |   | |     | (   |  \__   \__         //
//         V V   \__   \__| |    \__/ |   | \___/ |  \__| ____) ____)        //
///////////////////////////////////////////////////////////////////////////////

WWWeaponClass::WWWeaponClass (const String& name, const StringMap& params) {
	// Read class attributes from the map
	mName			= name;
	mRange			= params[name + ".range"];
	mEnergy			= params[name + ".energy"];

	// Currently only one ammo class. Perhaps the ammo should be
	// handled in an OO-style too. Yes, definitely. But, since we now
	// have only one kind of weapon, and ammo, we'll leave that for
	// future.
	mAmmoClass		= AC_BEAM;
}



///////////////////////////////////////////////////////////////////////////////
//          |   | |   | |   |       o      ___  |                            //
//          | | | | | | |   |   _      |  /   \ |  ___   ____  ____          //
//          | | | | | | |   | |/ \  | -+- |     |  ___| (     (              //
//          | | | | | | |   | |   | |  |  |     | (   |  \__   \__           //
//           V V   V V  `___ |   | |   \ \___/ |  \__| ____) ____)          //
///////////////////////////////////////////////////////////////////////////////

WWUnitClass::WWUnitClass (const String& name, const StringMap& params) {
	// Read class attributes from the map
	mName			= name;
	mId				= params[name + ".id"];
	mMaxHits		= params[name + ".hitpoints"];
	mWeaponName		= getOrDefault (params, name + ".weapon", String(""));
	mArmour			= getOrDefault (params, name + ".armour", String("0"));
	mSpeed			= getOrDefault (params, name + ".speed", String("0"));
	mRotSpeed		= getOrDefault (params, name + ".rotspeed", String("0"));
	mResourceCost	= params[name + ".cost"];
	mBuildTime		= params[name + ".buildtime"];
	mBuilds			= getOrDefault (params, name + ".builds", String(""));
	mBuildEffic		= getOrDefault (params, name + ".buildefficiency", String("0"));
}

WWUnitInst* WWUnitClass::newUnit (WWPlayer* player) const {
	return new WWUnitInst (*this, static_cast<WWObject*>(player));
}



///////////////////////////////////////////////////////////////////////////////
//                |   | |   | |   |       o     |     o                      //
//                | | | | | | |   |   _      |  |       |                    //
//                | | | | | | |   | |/ \  | -+- |     | |---                 //
//                | | | | | | |   | |   | |  |  |     | |   )                //
//                 V V   V V  `___ |   | |   \ |____ | |__/                 //
///////////////////////////////////////////////////////////////////////////////

void WWUnitLib::make (const StringMap& params) {
	Array<String> units;
	params["WWorld.units"].trim().split (units, ' ');
	for (int i=0; i<units.size; i++)
		mUnitClasses.add (new WWUnitClass (units[i], params));
}

/*static*/ const WWUnitClass* WWUnitLib::unitClass (const String& name) {
	for (int i=0; i<gUnitLib.mUnitClasses.size; i++)
		if (gUnitLib.mUnitClasses[i].name() == name)
			return &gUnitLib.mUnitClasses[i];
	return NULL;
}

/*static*/ const WWUnitClass* WWUnitLib::unitClass (int classid) {
	for (int i=0; i<gUnitLib.mUnitClasses.size; i++)
		if (gUnitLib.mUnitClasses[i].id() == classid)
			return &gUnitLib.mUnitClasses[i];
	return NULL;
}

/*static*/ WWUnitInst* WWUnitLib::newUnit (const String& name, WWPlayer* player) {
	if (const WWUnitClass* uclass = gUnitLib.unitClass (name))
		return uclass->newUnit (player);
	else
		return NULL;
}



//////////////////////////////////////////////////////////////////////////////
//           |   | |   |  ___                                   |           //
//           | | | | | | /   \                   ___    _       |           //
//           | | | | | | |      __  |/|/| |/|/|  ___| |/ \   ---|           //
//           | | | | | | |     /  \ | | | | | | (   | |   | (   |           //
//            V V   V V  \___/ \__/ | | | | | |  \__| |   |  ---|           //
//////////////////////////////////////////////////////////////////////////////

WWUnitState WWComMove::extrapolate (WWUnitInst& unit, double t) const return result {
}

bool WWComMove::execute (WWUnitInst& unit, WWWorld& world) {
	// Calculate exact direction to the target
	Radian direction = unit.location().direction (mTarget);;

	// If the unit is in search mode, turn to some other heading
	if (unit.searchMode()) {
		direction += M_PI/2;
		unit.searchMode (unit.searchMode()-1);
	}
		
	// Check if the current direction is wrong
	Radian current = unit.direction();
	printf ("d=%f current=%f round=%f\n", double(direction), double(current), double(direction.round8()));
	//if (fabs(current-direction) > M_PI)
	//	current += M_PI*2;
	if (current>(M_PI+M_PI/2) && direction<(M_PI+M_PI/2))
		direction += M_PI*2;
		
	if (fabs(current-direction) > 0.1) {
		// Turn the unit
		unit.turn (current + ((current-direction > 0)? -0.1 : +0.1));
	} else {
		// The direction is correct -> move forward
		unit.turn (direction); 
		
		// Calculate new coordinates
		WWCoord newPos (unit.location ().x + 0.1*cos (current),
						unit.location ().y + 0.1*sin (current));
		printf ("%s from (%f,%f) to direction %f to (%f,%f)...\n",
				unit.searchMode()? "Searching" : "Moving",
				unit.location().x, unit.location().y, current, newPos.x, newPos.y);
		
		// Try to move to that direction. If there is a collision, the
		// movement is not done, and moveTo returns NULL.
		if (!unit.moveTo (newPos))
			// The direction was blocked, go to search mode
			unit.searchMode (10);
		
		// Check if the unit has arrived at its destination
		if (newPos.distanceSqr (mTarget) < 0.1) {
			printf ("Unit arrived, stopping\n");
			return true; // We are at there
		}
	}
	return false;
}

bool WWComFire::execute (WWUnitInst& unit, WWWorld& world) {
	// WWMapSquare& sqr = world.map().getTerrain(mTarget);
	world.shootAt (unit, mTarget);
	printf ("Unit %d firing at coordinates (%f,%f)\n", unit.id(), mTarget.x, mTarget.y);

	// Check if we hit some unit
	for (int i=0; i<world.objectIds(); i++)
		if (WWUnitInst* trgUnit = dynamic_cast<WWUnitInst*>(world.object(i)))
			if (trgUnit->location().distance (mTarget) < 1.0) {
				printf ("Yesss, the firing hit unit %d!\n", i);
				if (trgUnit->addDamage (10))
					world.remove (i);
				else
					dynamic_cast<WWPlayer*>(trgUnit->owner())->unitHit (*trgUnit);
			}

	return true;
}

WWComBuild::~WWComBuild () {
	// Delete an unfinished unit, if such exists
	delete mpUnit;
}

bool WWComBuild::execute (WWUnitInst& builder, WWWorld& world) {
	// If we are just starting the building, we have to create the new
	// unit
	if (!mpUnit)
		mpUnit = new WWUnitInst (*mpClass, mpPlayer);

	// Calculate the work progress (1.0 would mean immediate building)
	double portion= world.ticTime() * builder.getClass().buildEfficiency()
		/ mpClass->buildTime();

	// Calculate the amount of resources needed to build the amount
	double resourceAmount = portion * mpClass->cost();
	
	// If the player has resources
	if (mpPlayer->resources() >= resourceAmount) {
		// Charge the construction cost from the player
		mpPlayer->changeRes (-resourceAmount);
		
		// Build the unit a little
		if (mpUnit->build (portion)) {
			// Build complete 
			world.add (mpUnit);			// Add the unit to the world
			WWCoord newpos = builder.location (); // Get current location
			for (int r=0; r<8; r++)		// Find a free location around it
				if (mpUnit->moveTo (newpos.around8(r)))
					break;				// A free location found

			mpUnit = NULL;				// Give up the ownership of the object
			return true;				// Building finished
		}
	}

	// Building still unfinished
	return false;
}



///////////////////////////////////////////////////////////////////////////////
//          |   | |   | |   |       o      ----                              //
//          | | | | | | |   |   _      |  (      |   ___   |   ___           //
//          | | | | | | |   | |/ \  | -+-  ---  -+-  ___| -+- /   )          //
//          | | | | | | |   | |   | |  |      )  |  (   |  |  |---           //
//           V V   V V  `___ |   | |   \ ___/    \  \__|   \  \__           //
///////////////////////////////////////////////////////////////////////////////

WWUnitState::operator= (const WWUnitState& other) {
	mLocation = other.mLocation;
	mDirection = other.mDirection;
	mTurretDir = other.mTurretDir;
}

/*virtual*/ WWUnitState* WWUnitState::moveTo (const WWCoord& pos) {
	mLocation = pos;
}

/*virtual*/ unsigned int WWUnitState::collision (const WWCoord& pos, WWWorld& world) const return result {
	WWMap& map = world.map();
	result = 0;

	// Check that the coordinates are legal
	if (int(pos.x)<0 || int(pos.x)>map.sizex()-1 ||
		int(pos.y)<0 || int(pos.y)>map.sizey()-1)
		result |= WWUICOLL_BORDER;

	// Determine the three "other" map squares which this unit
	// touches. Note that these squares can never be outside the map.
	double fractx = (1000+pos.x)-int(1000+pos.x);
	double fracty = (1000+pos.y)-int(1000+pos.y);
	int first8;
	if (fractx<0.5)
		if (fracty<0.5)
			first8 = 0;
		else
			first8 = 2;
	else
		if (fracty<0.5)
			first8 = 4;
		else
			first8 = 6;

	for (int i=first8; i<first8+3; i++) {
		// Check for collision with a terrain obstacle
		
		// Check if there is a unit in any of the three other squares
		if (WWUnitInst* otherUnit = map.getTerrain (pos.around8(i%8)).unit ())
			if (pos.distanceSqr (otherUnit->location()) < 1) {
				result |= WWUICOLL_UNIT;
				break;
			}
	}
}



///////////////////////////////////////////////////////////////////////////////
//             |   | |   | |   |       o     ---                             //
//             | | | | | | |   |   _      |   |    _    ____  |              //
//             | | | | | | |   | |/ \  | -+-  |  |/ \  (     -+-             //
//             | | | | | | |   | |   | |  |   |  |   |  \__   |              //
//              V V   V V  `___ |   | |   \ _|_ |   | ____)   \             //
///////////////////////////////////////////////////////////////////////////////

WWUnitInst::WWUnitInst (const WWUnitClass& uclass, WWObject* player)
		: WWObject (player), mpUnitClass(&uclass) {
	mHitpoints = getClass().maxhits();
	mBuildComplete = 0.0;
	mDirection = 0.0;
	mMoved = true;
	mSearchMode = 0;
	mId = -1;
}

WWUnitInst* WWUnitInst::moveTo (const WWCoord& pos) {
	WWMap& map = world().map();
	
	// Check that the coordinates are legal
	if (int(pos.x)<0 || int(pos.x)>map.sizex() ||
		int(pos.y)<0 || int(pos.y)>map.sizey())
		return NULL;

	// Check that there is not unit already in the location
	if (map.getTerrain (pos).unit() && map.getTerrain (pos).unit() != this)
		return NULL;

	// Ok, the move is legal
	
	// Set the current map square to refer to some no object
	if (mLocation.x>=0 && mLocation.y>=0)
		map.getTerrain (mLocation).setUnit (NULL);

	WWUnitState::moveTo (pos);

	// Set the new map square to know that we are there
	if (mLocation.x>=0 && mLocation.y>=0)
		map.getTerrain (mLocation).setUnit (this);

	mMoved = true;
	return this;
}


bool WWUnitInst::addDamage (double damage) {
	mHitpoints -= damage;
	return mHitpoints<0.0;
}

bool WWUnitInst::heal (double hitpoints) {
	mHitpoints += hitpoints;
	if (mHitpoints >= getClass().maxhits()) {
		mHitpoints = getClass().maxhits();
		return true;
	} else
		return false;
}

bool WWUnitInst::build (double amount) {
	mBuildComplete += amount;
	if (mBuildComplete >= 1.0) {
		mBuildComplete = 1.0;
		return true;
	} else
		return false;
}

void WWUnitInst::execute () {
	if (WWCommand* cmd = currentCommand())	// Get the current command
		if (cmd->execute (*this, world()))	// Execute the command
			removeCommand ();				// Command completed
}
