/**
 * $Author: magi $ $Date: 2000/01/30 22:20:39 $ $Revision: 1.9 $
 *
 * $Log: wwworld.h,v $
 * Revision 1.9  2000/01/30 22:20:39  magi
 * added wwbase.cc for WWObject handling
 *
 * Revision 1.8  2000/01/29 03:26:00  magi
 * wwplayer.h separated from wwworld.h
 *
 * Revision 1.7  2000/01/08 00:50:22  magi
 * Client connect/disconnect works. BUILD works, MOVE works partially.
 **/

#ifndef __WWWORLD_H__
#define __WWWORLD_H__

#include "magic/table.h"
#include "magic/pararr.h"

#include "wwmap.h"
#include "wwunit.h"
#include "wwplayer.h"
#include "wwformation.h"

//////////////////////////////////////////////////////////////////////////////
//                    |   | |   | |   |          |     |                    //
//                    | | | | | | | | |          |     |                    //
//                    | | | | | | | | |  __  |/\ |  ---|                    //
//                    | | | | | | | | | /  \ |   | (   |                    //
//                     V V   V V   V V  \__/ |   |  ---|                    //
//////////////////////////////////////////////////////////////////////////////

/** Contains all game objects.
 *
 *  This object is a singleton - only one instance exists at a given
 *  time, which can be accessed with the WWWorld::getWorld() method.
 **/
class WWWorld : public WWObjectSpace {
  public:
						WWWorld			() {mTimeTic=0.05; mpWorld=this;}
	virtual				~WWWorld		() {}

	/** Initializes the world to the given map size.
	 **/
	void				make			(int xsize, int ysize);

	/** Returns the map of the world.
	 **/
	WWMap&				map				() {return mMap;}

	/** Returns the object located at given coordinates, or NULL if no
	 *  object is located at those coordinates.
	 **/
	WWObject*			getObjectAt		(const WWCoord& pos);

	/** Length of a game tic in seconds. */
	double				ticTime			() const {return mTimeTic;}

	/** Returns the WWWorld singleton.
	 **/
	//static	WWWorld&	getWorld	() {return sTheWorld;}

	virtual				shootAt			(const WWUnitInst& unit, const WWCoord& target) {}

  protected:

	/** Creates random terrain, etc.
	 **/
	void				init		() {}
	
	/** The terrain map. */
	WWMap				mMap;

	/** Singleton instance */
	static WWWorld		sTheWorld;

	double				mTimeTic;

	/** Unit formation methods. */
	WWFormationLib		mFormationLib;
};

#endif
