/**
 * $Author: magi $ $Date: 2000/01/31 10:21:54 $ $Revision: 1.3 $
 *
 * $Log: wwserver.h,v $
 * Revision 1.3  2000/01/31 10:21:54  magi
 * Uses now the revised global objectid system
 *
 * Revision 1.2  2000/01/08 00:50:22  magi
 * Client connect/disconnect works. BUILD works, MOVE works partially.
 *
 **/

#include "wwlib/wwworld.h"

class ServerWorld; // Internal



///////////////////////////////////////////////////////////////////////////////
//        ----                           ----  |                             //
//       (      ___             ___      |   ) |  ___         ___            //
//        ---  /   ) |/\ |   | /   ) |/\ |---  |  ___| \   | /   ) |/\       //
//           ) |---  |    \ /  |---  |   |     | (   |  \  | |---  |         //
//       ___/   \__  |     V    \__  |   |     |  \__|   \_/  \__  |         //
//                                                      \_/                  //
///////////////////////////////////////////////////////////////////////////////

/** Server's instance of a player. Contains communications stuff, and
 *  all game logic.
 **/
class ServerPlayer : public WWPlayer {
  public:
						ServerPlayer	(WWWorld* owner, int socket,
										 const sockaddr_in& address);
	virtual				~ServerPlayer	();

	/** Returns the socket handle of the player client. */
	int					getSocket		() const {return mSocket;}

	/** Returns the IP address of the client as a dot-separated string. */
	String				ip				() const;

	/** Launches. Gives the player a factory at random location. */
	void				launch			();

	/** Gives the unit to the player. */
	//virtual int		addUnit			(WWUnitInst* unit);

	/** Changes the amount of resources of the player. */
	virtual bool		changeRes		(double amount);

	/** Adds a private message to the client's message send buffer. */
	void				addMsg			(const String& msg) {mMsgBuffer += msg;}

	/** Returns the client's private message send buffer. */
	const String&		msgBuffer		() const {return mMsgBuffer;}
	
	/** Clears the client's private message send buffer. */
	void				clearMsgs		() {mMsgBuffer="";}

	/** Send HIT information. */
	/*virtual*/ void	unitHit			(WWUnitInst& unit);
	
  protected:
	ServerWorld&		world			();
	
  protected:
	/** The socket for communicating with the player. */
	int					mSocket;

	/** The socket's INET address. */
	sockaddr_in			mAddress;

	/** Buffer for private outgoing messages. */
	String				mMsgBuffer;
};



//////////////////////////////////////////////////////////////////////////////
//           ----                           |   |          |     |          //
//          (      ___             ___      | | |          |     |          //
//           ---  /   ) |/\ |   | /   ) |/\ | | |  __  |/\ |  ---|          //
//              ) |---  |    \ /  |---  |   | | | /  \ |   | (   |          //
//          ___/   \__  |     V    \__  |    V V  \__/ |   |  ---|          //
//////////////////////////////////////////////////////////////////////////////

/** Server's instance of the world. Contains communications stuff, and
 *  all game logic.
 **/
class ServerWorld : public WWWorld {
  public:
						ServerWorld		(const StringMap& params);

	/** Application main loop. Accepts connections, runs the world by
	 *  timed ticks, and serves player clients.
	 **/
	void				run				();

	void				addPublicMsg	(const String& msg);

	String				scoreMsg		();

  protected: // Methods
	
	/** Creates the listening socket. */
	void				createSocket	();

	/** Creates a new player. */
	void 				createPlayer 	(int asock, const sockaddr_in& clientAddress);

	/** Adds an object and sends appropriate messages. */
	/*virtual*/ int		add				(WWObject* object);

	/** Removes an object and sends appropriate messages. */
	/*virtual*/ void	remove			(int objectId);

	/** Receives commands from clients. */
	void 				recvFromClients	();

	/** Processes a command from client. */
	void				handleCommand	(ServerPlayer& player, const Array<String>& command);
		
	/** Transmits the data buffers to. */
	void				sendToClients	();

	/** Clears the broadcast message buffer. */
	void				clearPublicMsgs	() {mPublicMsgs="";}

	/*virtual*/			shootAt			(const WWUnitInst& unit, const WWCoord& target);
	
	/** Creates a NEW message. */
	static String		newMsg			(const WWUnitInst& unit);

	/** Creates a POS message. */
	static String		posMsg			(const WWUnitInst& unit);

  protected: // Member variables
	
	/** Port number to listen to. */
	int					mPortNumber;

	/** The listening socket for the server. */
	int					mSocket;

	/** Listening socket INET address. */
	sockaddr_in			mAddress;

	/** Is the game running, i.e., has it been launched? */
	bool				mRunning;

	/** Number of game ticks ran so far. */
	int					mTime;

	/** Broadcast message buffer. Is cleared at the beginning of every
	 *  game cycle.
	 **/
	String				mPublicMsgs;

	int					mNewUnit; // KLUDGE
};
