// Enable all that junk code between the lines (YUCK :)
// (I guess you could ask what's there to compile after disabling ww_DEBUG..;)
#define ww_DEBUG
#define ww_VERSION_MAJOR 0
#define ww_VERSION_MINOR 0
//-----------------------------------------------------------------
// WarWorld Client v0.0     (ALPHA's ALPHA's Release Candidate I)
// (as of 31.01.2000)        
//
// * Part of an elementary programming project for
//   a Linux programming course.
//   (isn't it amazing what a 'motivated' computer science student
//    can come up with in less than 3 weeks?)
//
// * For a 2 cu course this is one cool, yet mega-lo-manic
//   project. :)
//-----------------------------------------------------------------
// Authors:
//-----------------------------------------------------------------
// THIS CLIENT SOFTWARE:
// Written in January 2000.
// Programming: Jani Argillander (japear@utu.fi) 
// Artwork:     Jani Argillander
//              Janne Argillander
//-----------------------------------------------------------------
// WarWorld SERVER SOFTWARE:
// Programming: Marko Grnroos (magi@utu.fi)
//-----------------------------------------------------------------
// Computer Science department (www.cs.utu.fi)
// University of Turku, Finland. 
//-----------------------------------------------------------------
// COMPILATION: You'll need the Qt 2.0 library (for KDE). (by Troll Tech)
// 
//              There's a script file called 'doqt' (no fancy makefiles) 
//              which attempts to compile this package given that path  
//              names are correct and the needed libraries are found.
//             
//              Simply: ./doqt
//              Creates an executable named 'wwclient' 
//
// NOTE: This is a project for experimenting with the Qt and Linux
//       APIs and thus is DEFINITELY NOT MEANT to be a demonstration
//       of how a sprite graphics engine or a game networking scheme 
//       should be constructed. Period. :)
//    
//          And you object oriented enthusiasts out there, I'd rather
//       not hear about the ugliness of this code.. :) 
//
//         As an API, Qt is extremely pleasant and easy to use as
//       opposed to the rather crappy GTK library. And is definitely
//       the API of choice for me.
//
// FUTURE: Although it goes without saying that there's a lot to do
//         before this software can be called a 'complete' game, 
//         at this time I really can't say whether or not we will keep
//         on developing this project. Thus, any feedback regarding this
//         project is welcome.  
//       
// FEEDBACK: Yes, any feedback regarding this client, especially
//           the bugs and the performance on different PC setups 
//           would be appreciated. Server and client related issues
//           should, of course, be relayed to the corresponding
//           developers.
//
// DEVELOPMENT HARDWARE:
//           500 MHz Pentium III
//           128 Mb RAM
//           32Mb Diamond Viper V770 TNT2
//           Powered by Red Hat Linux 6.1 (KDE v1.1.2 + Qt 2.x)
//           
//           Unfortunately, I didn't have the time to test this
//           on my most treasured possession, a 66MHz 486DX2 with
//           32Mb of RAM and a 1Mb Cirrus Logic 5428 video card. :) 
//           The test would have given a good feel on how this
//           code performs on a wide range of machines.
// 
//-----------------------------------------------------------------
// SHOULD YOU CONSIDER USING PARTS OF THIS CODE, AN ENTRY IN THE
// CREDITS IS ALL I ASK. OTHERWISE, THIS IS FREE STUFF. WHEE!
//-----------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <qapplication.h>
#include <qframe.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qscrollview.h>
#include <qbitmap.h>
#include <qcursor.h>
#include <qevent.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qsemimodal.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlineedit.h>

#include <qsocketnotifier.h>

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>  // man inet
#include <arpa/inet.h>

#include "wwproto.cc"
#include "wwtypeid.cc"
#include "wwbase.cc"
#include "wwgamestats.cc"

//============================================================================
#define WW_DEFAULT_MAIN_WINDOW_WIDTH  680
#define WW_DEFAULT_MAIN_WINDOW_HEIGHT 500
//============================================================================
// Ahh, sometimes you just gotta love global data..
// 
   static bool             this_player_is_host = FALSE;
   bool                    thisPlayerIsHost() { return (this_player_is_host); };
   void                    setThisPlayerIsHost( bool f ) { this_player_is_host = f; };
// The battle field.
   static C_BattleField    battle_field;
   static C_BattleField   *battleField() { return (&battle_field); };

// Desired frame rate
   static int      ww_frame_rate;
   static int      frameRate() { return (ww_frame_rate); };
   static void     setFrameRate( int fps ) { ww_frame_rate = fps; };

// Handle game time
   static unsigned long   ww_game_ticks;
   // methods

   static void            incrementGameTicks() { ww_game_ticks++; };
   static void            resetGameTicks() { ww_game_ticks=0; };
   static unsigned long   gameTicks() { return (ww_game_ticks); };
// Everything's drawn on this one.   
   static C_DrawSurface  *windowDrawSurface;

   static C_FramePool     game_sprite_pool;
   static C_FramePool     game_extras_pool;

   static short           this_player_id;
   // Methods
   static short           thisPlayerID() { return (this_player_id); };
   static void            setThisPlayerID ( short id ) { this_player_id = id; };
   
   static char           *this_player_nick;
   static char           *thisPlayerNick() { return (this_player_nick); };   
   static void            setThisPlayerNick ( char *nick ) {   
      this_player_nick = new char[strlen(nick)+1];     
      strcpy(this_player_nick, nick);    
   }
  
// General animation related data
   static C_FrameList     gfx_red_tank_base_framelists[16];
   static C_FrameList     gfx_green_tank_base_framelists[16];
   static C_FrameList     gfx_blue_tank_base_framelists[16];
   static C_FrameList     gfx_yellow_tank_base_framelists[16];

   static C_FrameList     gfx_red_tank_barrel_framelists[16];
   static C_FrameList     gfx_green_tank_barrel_framelists[16];
   static C_FrameList     gfx_blue_tank_barrel_framelists[16];
   static C_FrameList     gfx_yellow_tank_barrel_framelists[16];

   static C_FrameList     gfx_explosion_framelist;
   static C_FrameList     gfx_spawn_framelist;
   static C_FrameList     gfx_hit_framelist;
   static C_FrameList     gfx_crater_framelist;
   static C_FrameList     gfx_flame_framelists[16];    

   static C_FrameList     gfx_red_tankfactory_framelist;
   static C_FrameList     gfx_green_tankfactory_framelist;
   static C_FrameList     gfx_blue_tankfactory_framelist;
   static C_FrameList     gfx_yellow_tankfactory_framelist;

   static C_FrameList     gfx_unit_selector_framelists[1];
   
   #define ww_MAX_ACTIVE_SPRITES 2000
// This should fix problems with asynchronously destroyed units' backgrounds.
   static long            num_active_sprites=0;
   static C_Sprite       *active_sprites[ww_MAX_ACTIVE_SPRITES];
// The methods
   static void            addActiveSprite ( C_Sprite *s ) {
     if (num_active_sprites < ww_MAX_ACTIVE_SPRITES) {
       active_sprites[num_active_sprites] = s;
       num_active_sprites++;
     } else printf("WARN: addActiveSprite() failed! Too many sprites. (ww_MAX_ACTIVE_SPRITES == %i)\n",ww_MAX_ACTIVE_SPRITES); 
   }
   static C_Sprite       *iterateActiveSpritesReversed() {
     num_active_sprites--;
     if (num_active_sprites < 0) {
       num_active_sprites = 0;
       return NULL;
     }
     return (active_sprites[num_active_sprites]);
   }
   
   // 'Detail sprites' are separated from the standard sprite pipeline
   // in order to draw them on top of everything else.  
   static C_Sprite *detail_sprite_list_head;

   static C_Sprite *detailSpriteList() { return detail_sprite_list_head; };
   static void addDetailSprite ( C_Sprite *s, short x, short y ) {
     if (s) {
       // Let's interpret sprite offsets for detail sprites as their 'coordinates'. 
       s->setXYOffsets(x, y);
       detail_sprite_list_head->attach(s);
     } else ww_FATAL_ERROR("addDetailSprite(*s) failed! (s == NULL)!\n");
   }
// Child window(s)
   static WWGameStatistics *game_statistics_window;

// General game controls related variables...
   static short    num_units_selected;
   // Methods

   static void     incrementNumUnitsSelected() { num_units_selected++; };
   static void     decrementNumUnitsSelected() { num_units_selected -= (num_units_selected > 0); };
   static void     resetUnitsSelected() { num_units_selected=0; };
   static short    numUnitsSelected() { return (num_units_selected); };

   static bool     unit_visible[ww_MAX_TOTAL_UNITS];
   // Methods
   static bool     unitIsVisible ( short unit_id ) {
     if (unitIDBoundsCheck(unit_id)) {
       return (unit_visible[unit_id]); 
     } else ww_FATAL_ERROR("unitIsVisible() failed! unit_id out of bounds!\n"); 
   }
   static void     markUnitVisible ( short unit_id ) {
     if (unitIDBoundsCheck(unit_id)) {
       unit_visible[unit_id] = TRUE;
     } else ww_FATAL_ERROR("markUnitVisible() failed! unit_id out of bounds!\n");
   }
   static void     markUnitInvisible ( short unit_id ) {
     if (unitIDBoundsCheck(unit_id)) {
       unit_visible[unit_id] = FALSE;
     }
   }
   static void     resetVisibilityInfo() {
     for (short i=0 ; i<ww_MAX_TOTAL_UNITS ; i++)
       markUnitInvisible(i);
   }
// Communications related data
   // WarWorld server's IP address
   static char           *ww_comm_serverAddress;
   // Port number
   static unsigned short  ww_comm_serverPort;
   // Methods
   static unsigned short  serverPort() { return (ww_comm_serverPort); };
   static char           *serverAddress() { return (ww_comm_serverAddress); };
   // NOTE! This routine takes care of endianity.
   static void            setServerPort ( unsigned short p ) { ww_comm_serverPort = (p << 8) | (p >> 8); };
   static void            setServerAddress ( char *addx ) {            
      ww_comm_serverAddress = new char[strlen(addx)+1];      
      strcpy(ww_comm_serverAddress, addx);     
   }
   int                    ww_comm_socketfd;
   bool                   ww_received_gamestate;
   bool                   ww_gameinit_complete;
   bool                   gameInitComplete() { return (ww_gameinit_complete); };
   bool                   ww_gameaborted;
   // Returns an angle value between [0..255] for a given vector.    
   static float getAngle256ForVector ( float i_c, float j_c ) {
      const float pi=3.1415927;
      float a;
      float angle256;            
      a = atan2(j_c, i_c);
      if (a < 0.000001) {
	 a = 2*pi + a;
      } 
      angle256 = ((float) a*256.0/(2.0*pi));
      angle256 = (angle256 > 255) ? 255.0 : angle256;
      angle256 = (angle256 < 0.00001) ? 0.0 : angle256;
      return(angle256);            
   }
//===========================================================================
   void ww_comm_sendPlayerData() {
     char temp[128];
     sprintf(temp, "%s %s\n", ww_c_ENTER, thisPlayerNick());
     write(ww_comm_socketfd, temp, strlen(temp));
   }
   void ww_comm_sendLaunchCommand() {
      char temp[16];
      sprintf(temp, "%s\n", ww_c_LAUNCH_GAME);
      write(ww_comm_socketfd, temp, strlen(temp));
   }
   void ww_comm_sendBuildMessage ( short type_id ) {
      char temp[15];   
      
      sprintf(temp, "%s %i 1 1\n", ww_c_BUILD_COMMAND, type_id);
      write(ww_comm_socketfd, temp, strlen(temp));
#ifdef ww_DEBUG
      printf("ww_comm_sendBuildMessage() wrote: %s\n", temp);
#endif      
   }

   void ww_comm_sendMousePositionMessage() {
      char temp[30];
      sprintf(temp, "%s %i %i\n", ww_c_MOUSE_POS, 
	                        battle_field.playerMouseX(thisPlayerID()),
	                        battle_field.playerMouseY(thisPlayerID()));
      write(ww_comm_socketfd, temp, strlen(temp));
#ifdef ww_DEBUG
      printf("ww_comm_sendMousePositionMessage() wrote: %s\n", temp);
#endif
   }

   void ww_comm_sendUnitSelectionMessage ( short unit_id, bool send ) {
      static char sel_buffer[512];
      static char *rover = sel_buffer;
      char temp[15];
      if (!send) {
	 if (rover == sel_buffer) {
	    sprintf(rover, "%s %i", ww_c_SELECTED, unit_id);
	    rover += strlen(rover);
	 } else {
	    sprintf(temp, " %i", unit_id);
	    sprintf(rover, "%s", temp);
	    rover += strlen(temp);
	 }
      }
      if (send) { 
#ifdef ww_DEBUG
	 printf("ww_comm_sendUnitSelectionMessage() wrote: %s\n", sel_buffer);
#endif  
        sprintf(rover, "\n"); rover++;   	 
	write(ww_comm_socketfd, sel_buffer, (rover - sel_buffer));	
	rover = sel_buffer;
      }
                         	      
   }
   // This routine sends a fire command to the server.
   void ww_comm_sendFireCommand( short target_x, short target_y ) {
      char temp[10];      
      sprintf(temp, "%s 1 1\n", ww_c_FIRE_COMMAND);
      write(ww_comm_socketfd, temp, strlen(temp));
#ifdef ww_DEBUG
      printf("ww_comm_sendFireCommand() wrote: %s\n", temp);
#endif      
   }

   // Tell the server that we wish to redeploy.
   void ww_comm_sendMoveCommand( short dest_x, short dest_y ) {
      char temp[10];
      sprintf(temp, "%s 0\n", ww_c_MOVE_COMMAND);
      write(ww_comm_socketfd, temp, strlen(temp));
#ifdef ww_DEBUG
      printf("ww_comm_sendMoveCommand() wrote: %s\n", temp);
#endif       
   }

  void ww_comm_sendSynch() {
    char tmp[10];
    sprintf(tmp, "%s\n", ww_c_SYNCHRONIZE);
    write(ww_comm_socketfd, tmp, strlen(tmp));
  }

  void ww_comm_sendQuitMessage() {
    char tmp[10];
    printf("ww_comm_sendQuitMessage() wrote: %s\n", ww_c_QUIT); 
    sprintf(tmp, "%s\n", ww_c_QUIT);
    write(ww_comm_socketfd, tmp, strlen(tmp));
  }
  bool globalCommInitialize ( QObject *receiver ) {
    // Networking related info:
    // MAN inet ip     
    struct sockaddr_in sa;
    ww_received_gamestate = FALSE;
    ww_gameinit_complete = FALSE;
    ww_gameaborted = FALSE;

    if (serverAddress()) {	
      sa.sin_family = AF_INET;
      sa.sin_port = serverPort();
      sa.sin_addr.s_addr = inet_addr(serverAddress());
        
      ww_comm_socketfd = socket(PF_INET, SOCK_STREAM, 0);
      if (ww_comm_socketfd == -1) {
        printf("globalCommInitialize() failed! Can't get a socket!\n");
        return FALSE;
      }      	
      if (::connect(ww_comm_socketfd, (struct sockaddr *)&sa, sizeof(sa)) == -1)
        return FALSE;

      QSocketNotifier *sn = new QSocketNotifier(ww_comm_socketfd, QSocketNotifier::Read, receiver);
      QObject::connect(sn, SIGNAL(activated(int)), receiver, SLOT(commInputHandler()));
	 
      return TRUE;
    } 
    return FALSE; 
  }

  void globalCommKill() {
    close(ww_comm_socketfd);
  }  
//============================================================================

// And now, the 'game engine'.
class WWGameEngine : public QScrollView {
   Q_OBJECT
 protected:    

   // keep 'em defs somewhere else!
   #include "wwspritedefs.cc"
   #include "wwunitdefs.cc"

   void makeUnit ( short unit_id, short player_id, short wx, short wy, short heading, short type_id ) {
      switch (type_id) {
       case ww_TYPEID_TANK:
	 battleField()->allocUnit(unit_id, new WWTank(unit_id, player_id, wx, wy, heading));
         battleField()->unit(unit_id)->setSprite(new WWTankSprite(player_id));
	 break;
       case ww_TYPEID_TANK_FACTORY:
         battleField()->allocUnit(unit_id, new WWTankFactory(unit_id, player_id, wx, wy, heading));
         battleField()->unit(unit_id)->setSprite(new WWTankFactorySprite(player_id)); 
	 printf("Someone wanted to build a builder and there's no materials to build one....(gosh)\n");
	 break;
      }     
   }

   void hitUnit ( short unit_id, short energy_remaining ) {
      C_Unit *unit = battleField()->unit(unit_id);

      unit->setHull(energy_remaining);
      //if (unit) {
      //	 unit->hitUnit(energy_remaining);
      //} else ww_FATAL_ERROR("WWGameEngine::hitUnit() failed! Unit does not exist!\n");
   }
 
   void unitShoot ( short unit_id, short x, short y ) {
      C_Unit *unit = battleField()->unit(unit_id);
      if (unit)
         unit->unitShoot();
    
      addDetailSprite(new WWHitSprite, x, y); 
   }

   // Make a new unit with that cool 'spawn' effect.. :)  
   void spawnUnit ( short unit_id, short player_id, short wx, short wy, short heading, short type_id ) {
     C_Unit *unit;                
     makeUnit(unit_id, player_id, wx, wy, heading, type_id);
     if (battleField()->unitExists(unit_id)) { 
       unit = battleField()->unit(unit_id);
       unit->spawnUnit();
     } else printf("WWGameEngine::spawnUnit() WARN: could not get memory for a new unit!\n");     
   }

   // This one makes a zombie out of a regular tank...
   // (A zombie == an exploding unit)
   // I'm not going to explain to you why this is needed..
   void destroyUnit ( short unit_id ) {      //, short victor_id ) {
      C_Unit *unit = battleField()->unit(unit_id);
      if (unit) {
	 if (unit->alive()) {
	    unit->destroyUnit();
	    // Update player stats accordingly.
	    //  battleField()->player(victor_id)->setKills(battleField()->player(victor_id)->kills()+1);
	    //   game_statistics_window->updateStats();
	 }
      } else ww_FATAL_ERROR("WWGameEngine::destroyUnit() failed! Unit non-existent!\n");                
   }

   // Surrender?! 
   // If a player surrenders all his units will explode at once.
   void doSurrender ( short player_id ) {
     C_Unit *unit = battle_field.firstExistingUnit();
     C_Unit *next_unit;
     while(unit) {
       next_unit = unit->nextUnit();
       if (unit->ownerPlayerID() == player_id) {
   	 destroyUnit(unit->unitID());
       }	 
       unit = next_unit;
     } 
   }   

   void clearSelections ( short owner_id ) {
      C_Unit *unit = battle_field.firstExistingUnit();
      
      while(unit) {
         if (unit->ownerPlayerID() == owner_id) {
	    unit->unselect();
	 }	 
	 unit = unit->nextUnit();
      }
   }
 
public slots:
   void commConsentToLaunch() {
      showLaunchDialog(FALSE);
      ww_comm_sendLaunchCommand();
   }
protected:  
  static const int DEFAULT_COMM_INPUT_BUFFER_SIZE = 4096;
  char *comm_inputBuffer;
  int   comm_inputBufferSize;  

  void commParseMousePosMessage ( char *cmd ) {
    short player_id;
    char *param;

    param = strsep(&cmd, " ");
    player_id = atoi(param);
    if (player_id < battle_field.numPlayers()) {
    //    if (player_id != thisPlayerID()) {
      param = strsep(&cmd, " ");
      battle_field.setPlayerMouseX(player_id, atoi(param));
      battle_field.setPlayerMouseY(player_id, atoi(cmd));
      //}
    } else printf("WARN: commParseMousePosMessage(): PLAYER_ID out of bounds!\n");
  }
 
  void commParseSelectionMessage ( char *cmd ) {
    short player_id;
    char *param;
    int i;

    param = strsep(&cmd, " ");
    player_id = atoi(param);
    if (player_id != thisPlayerID()) {
      clearSelections(player_id);
    
      while((param = strsep(&cmd, " ")) != NULL) {
	i = atoi(param);
	if (battle_field.unitExists(i)) {
          if (player_id == battle_field.unit(i)->ownerPlayerID()) 
	    battle_field.unit(i)->select();
	}		 
      }
    }
  }

  void commParseFireCommand ( char *cmd ) {
    short unit_id;
    short x, y;    
    char *param;
 
    param = strsep(&cmd, " ");
    unit_id = atoi(param);
    param = strsep(&cmd, " ");
    x = atoi(param);
    y = atoi(cmd);		  
    
    printf("SHOT: unit %i at (%i,%i)\n",unit_id,x,y);

    if (battle_field.unitExists(unit_id)) {
      unitShoot(unit_id, x, y);
    } else printf("WARN: commParseFireCommand(): unit #%i does not exist!\n", unit_id);
  }
#if 0
  void commParseDestroyMessage ( char *cmd ) {
    short unit_id;    

    unit_id = atoi(cmd);
    printf("DESTROYED: unit %i\n", unit_id);
    if (battle_field.unitExists(unit_id)) {
      destroyUnit(unit_id);
    }  
  }
#endif
  void commParseHitMessage ( char *cmd ) {
    short unit_id, energy_remaining;
    char *param;
  
    param = strsep(&cmd, " ");
    unit_id = atoi(param);
    energy_remaining = atoi(cmd);
    
    if (battle_field.unitExists(unit_id)) {
      if (energy_remaining == 0) {
	// destroy it
        printf("DESTROYED: unit %i\n", unit_id);
        destroyUnit(unit_id);
      } else {
	printf("HIT: unit %i energy remaining %i\n", unit_id, energy_remaining);
	hitUnit(unit_id, energy_remaining);
      }
    }
  }
  void commParseUnitPosMessage ( char *cmd ) {
    short unit_id;
    char *param;

    param = strsep(&cmd, " ");
    unit_id = atoi(param);
    
    if (battle_field.unitExists(unit_id)) {
      param = strsep(&cmd, " ");
      battle_field.unit(unit_id)->setWorldX(atoi(param));
      param = strsep(&cmd, " ");
      battle_field.unit(unit_id)->setWorldY(atoi(param));
      battle_field.unit(unit_id)->setHeading(atoi(cmd));  
    }
  }
  void commParseNewUnitInfo ( char *cmd ) {
    short player_id, unit_id, type_id;
    char *param;

    printf("Got New Unit!\n");
    param = strsep(&cmd, " ");
    player_id = atoi(param);
    param = strsep(&cmd, " ");		
    unit_id = atoi(param);
    type_id = atoi(cmd);
    spawnUnit(unit_id, player_id, 0, 0, 0, type_id);
  }
  void commParseResourceInfo ( char *cmd ) {
    QString tmp1, tmp2;
    char *param;
    param = strsep(&cmd, " "); 
    battle_field.player(thisPlayerID())->setResources((float) atof(param));   
  }
  void commParseScoreInfo ( char *cmd ) {
    char *param;
    short player_id=0;

    while ((param = strsep(&cmd, " ")) != NULL) {
      if (player_id < battle_field.numPlayers()) {
	battle_field.player(player_id)->setKills(atoi(param));
        param = strsep(&cmd, " ");
	battle_field.player(player_id)->setLosses(atoi(param));
       
      } else printf("==== WARNING: commParseScoreInfo(): excess player_id!\n");

      player_id++;
    }
    game_statistics_window->updateStats();
  }
  void commParsePlayerInfo ( char *cmd ) {
    char *param;
    short id;
    int i;
    // get PLAYER_ID
    param = strsep(&cmd, " ");
    id = atoi(param);
    i = battle_field.numPlayers();
    battle_field.setNumPlayers(i+1);
    // get IP address
    param = strsep(&cmd, " ");
    // Trash IP (of no use as of 29/01/2000)
    // Get player's nickname.  
    battle_field.player(id)->setNickName(cmd);
    printf("* Player %i: %s\n", id,
	   battle_field.player(id)->nickName());
    if (strcmp(battle_field.player(id)->nickName(), thisPlayerNick()) == 0) {
      setThisPlayerID(id);
      if (id == 0) 
	setThisPlayerIsHost(TRUE);
    }
    if (!gameInitComplete()) showLaunchDialog(TRUE);
     
  }
  void commParsePlayerQuitMessage ( char *cmd ) {
    char temp[256];
    short player_id = atoi(cmd);
    printf("WWClient: PLAYER %i LEFT THE GAME.\n", player_id);
   
    doSurrender(player_id);
    sprintf(temp, "%s committed suicide. War is hell.", battleField()->player(player_id)->nickName());
    QMessageBox::information(this, "Defeated!", temp, "Okay.");
  }
  void commParseMapInfo ( char *cmd ) {
    char *param;
    param = strsep(&cmd, " ");
    battle_field.setMapWidth(atoi(param));
    param = strsep(&cmd, " ");
    battle_field.setMapHeight(atoi(param));		  		 
    battle_field.setMapSeed(atoi(cmd));
    printf("WWClient: Map: %i x %i seed %i\n", battle_field.mapWidth(), 
	                                       battle_field.mapHeight(),
	                                       battle_field.mapSeed());	 
  }
  void commParseWaypointInfo ( char *cmd ) {
    char *param;
    int i;
    param = strsep(&cmd, " ");
    i = atoi(param);
    if (battle_field.unitExists(i)) {
      param = strsep(&cmd, " ");
      battle_field.unit(i)->setWayPointX(atoi(param));
      battle_field.unit(i)->setWayPointY(atoi(cmd));
    }
  }
  
  void commParseVersionInfo ( char *cmd ) {
    printf("WWClient: Server version %s responded.\n", cmd);
  }
  void commParseErrorInfo ( char *cmd ) {
    char *error_str;
    char temp[1024];
    int error_num;

    error_num = atoi(strsep(&cmd, " "));
    error_str = cmd;
    printf("ERROR %i: %s", error_num, error_str);

    sprintf(temp, "WWServer: Error %i: %s", error_num, error_str);
    if (QMessageBox::critical(NULL, "WarWorld Client v0.0 - Networking Error", temp, "Quit") == 0) {
      exit(0);
    }  
  }
  

public slots:
  void commInputHandler( void ) {
     int num_bytes;
     char *cmd_str, *cmd;
     char *param_str;
     char *rover;
     // Initialize buffering if necessary
     if (!comm_inputBuffer) {
       comm_inputBuffer = new char[DEFAULT_COMM_INPUT_BUFFER_SIZE];
       comm_inputBufferSize = DEFAULT_COMM_INPUT_BUFFER_SIZE;
       printf("commInputHandler(): comm_inputBuffer initialized.\n");
     } 
     // Let's see how many bytes are available for crunching.  
     ioctl(ww_comm_socketfd, FIONREAD, &num_bytes);
     if (num_bytes > comm_inputBufferSize) {
       if (comm_inputBuffer) 
	 delete comm_inputBuffer;
       // double the size
       comm_inputBufferSize = num_bytes * 2;
       comm_inputBuffer = new char[comm_inputBufferSize];       
        
       printf("commInputHandler(): growing comm_inputBuffer (2X).\n");
     }
     // Is everything ok?
     if (!comm_inputBuffer) 
       ww_FATAL_ERROR("FATAL: commInputHandler() failed! Could not get memory for buffering!\n"); 
     num_bytes = read(ww_comm_socketfd, comm_inputBuffer, num_bytes);     
     
     rover = comm_inputBuffer;
     while (rover <= &comm_inputBuffer[num_bytes-1]) {
       cmd_str = strsep(&rover, "\n");
       if (!cmd_str) ww_FATAL_ERROR("commInputHandler() failed: Undecipherable data received. Aborting.\n");

#ifdef ww_DEBUG
       printf("READ: %s\n", cmd_str);
#endif
       // Get the command part
       cmd = strsep(&cmd_str, " ");
       param_str = cmd_str;      
       // Identify messages and act accordingly.
       switch (ww_s_GetInGameCommandID(cmd)) {

       case ww_s_IS_UNIT_POSITION: commParseUnitPosMessage(param_str);  break;
       case ww_s_IS_MOUSE_POS:     commParseMousePosMessage(param_str); break;
       case ww_s_IS_CLIENT_RESET:
	 printf("=== NEW FRAME ===\n");         
       break;
       case ww_s_IS_SELECTED:     commParseSelectionMessage(param_str); break;
       case ww_s_IS_FIRE_COMMAND: commParseFireCommand(param_str);      break;
       case ww_s_IS_WAYPOINT:     commParseWaypointInfo(param_str);     break;
       case ww_s_IS_HIT:          commParseHitMessage(param_str);       break;
       case ww_s_IS_NEW_UNIT:     commParseNewUnitInfo(param_str);      break;
	 //case ww_s_IS_DESTROYED:    commParseDestroyMessage(param_str);   break;
       case ww_s_IS_SCORE:        commParseScoreInfo(param_str);        break;
       case ww_s_IS_RESOURCES:    commParseResourceInfo(param_str);     break;
       case ww_s_IS_END_OF_DATA:  ww_comm_sendSynch();                   break;

       // Session initialization/termination-related messages.
       // These are naturally of lower priority than those in-game messages above.
       case ww_s_IS_PLAYER_INFO:  commParsePlayerInfo(param_str); break;

       case ww_s_IS_INIT_DONE: 
         printf("WWClient: Launching..\n");
         ww_gameinit_complete = TRUE;
	 break;
       case ww_s_IS_MAP_INFO:    commParseMapInfo(param_str);           break;
       case ww_s_IS_PLAYER_QUIT: commParsePlayerQuitMessage(param_str); break;
       case ww_s_IS_VERSION:     commParseVersionInfo(param_str);       break;
       case ww_s_IS_ERROR:       commParseErrorInfo(param_str);         break;
       default:
	 printf("commInputHandler(): Unknown message: %s (discarded)\n",cmd_str);
       };            
     }     
   } 


protected:
  
//==================================================================
// Initialize sprite graphics
   void globalGraphicsInitialize() {
      bool result;
      int i;
      
      detail_sprite_list_head = new C_Sprite;
      detail_sprite_list_head->setDontDraw(TRUE);
      // Load sprite graphics
      if (!game_sprite_pool.allocFrames(4*16*2+9+1+1+6+9+16+4)) 
	 ww_FATAL_ERROR("WWGameWindow::globalGraphicsInitialize() failed! Could not get memory for game_sprite_pool!\n");
      // Assume success 
      result = TRUE;
      result &= game_sprite_pool.incrementalLoadFramesAt(0, 16, "rbase", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(16,16, "rbar", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(32,16, "gbase", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(48,16, "gbar", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(64,16, "bbase", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(80,16, "bbar", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(96,16, "ybase", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(112, 16, "ybar", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(128, 9, "exp", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(137, 1, "crater", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(138, 1, "ammo", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(139, 6, "hit", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(145, 9, "spawn", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(154, 16, "flame", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(170, 1, "rfact", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(171, 1, "gfact", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(172, 1, "bfact", ".bmp");
      result &= game_sprite_pool.incrementalLoadFramesAt(173, 1, "yfact", ".bmp");      

      if (!result) 
	ww_FATAL_ERROR("WWGameWindow::globalGraphicsInitialize() failed! Could not load graphics data!\n");
      
      // Load extra sprite graphics 
      // This means unit selectors and cursors and the like...
      if (!game_extras_pool.allocFrames(1)) ww_FATAL_ERROR("WWGameWindow::globalGraphicsInitialize() failed! Could not get memory for game_extras_pool!\n");
      if (!game_extras_pool.incrementalLoadFramesAt(0, 1, "extra", ".bmp")) {
	 ww_FATAL_ERROR("WWGameWindow::globalGraphicsInitialize() failed! Could not load extra_graphics!\n");
      }

      // Prepare game sprite graphics for use.
      result = TRUE;  // assume success
      for (i=0 ; i<16 ; i++) {
	 result &= gfx_red_tank_base_framelists[i].allocFrameList(1);
	 result &= gfx_green_tank_base_framelists[i].allocFrameList(1);
	 result &= gfx_blue_tank_base_framelists[i].allocFrameList(1);
	 result &= gfx_yellow_tank_base_framelists[i].allocFrameList(1);
	 
	 result &= gfx_red_tank_barrel_framelists[i].allocFrameList(1);
	 result &= gfx_green_tank_barrel_framelists[i].allocFrameList(1);
	 result &= gfx_blue_tank_barrel_framelists[i].allocFrameList(1);
	 result &= gfx_yellow_tank_barrel_framelists[i].allocFrameList(1);

         result &= gfx_flame_framelists[i].allocFrameList(2);	 

	 if (!result) 
	   ww_FATAL_ERROR("WWGameWindow::globalGraphicsInitialize() failed! Could not get memory for tank framelists!\n");
	 
	 gfx_red_tank_base_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_red_tank_base_framelists[i].setFrameNumberAt(0, i);	 
	 gfx_green_tank_base_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_green_tank_base_framelists[i].setFrameNumberAt(0, i+32);
	 gfx_blue_tank_base_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_blue_tank_base_framelists[i].setFrameNumberAt(0, i+64);
	 gfx_yellow_tank_base_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_yellow_tank_base_framelists[i].setFrameNumberAt(0, i+96);
	 
	 gfx_red_tank_barrel_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_red_tank_barrel_framelists[i].setFrameNumberAt(0, i+16);
	 gfx_green_tank_barrel_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_green_tank_barrel_framelists[i].setFrameNumberAt(0, i+48);
	 gfx_blue_tank_barrel_framelists[i].setFramePool(&game_sprite_pool);
         gfx_blue_tank_barrel_framelists[i].setFrameNumberAt(0, i+80);
	 gfx_yellow_tank_barrel_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_yellow_tank_barrel_framelists[i].setFrameNumberAt(0, i+112);
	 
         gfx_flame_framelists[i].setFramePool(&game_sprite_pool);
	 gfx_flame_framelists[i].setFrameNumberAt(0, i+154);
         gfx_flame_framelists[i].setFrameNumberAt(1, i+154);
      }
      // Prepare for explosions.
      gfx_explosion_framelist.setFramePool(&game_sprite_pool);
      gfx_explosion_framelist.allocFrameList(9);
      for (i=0 ; i<9 ; i++) {
         gfx_explosion_framelist.setFrameNumberAt(i, 128+i);
      }
      gfx_crater_framelist.allocFrameList(1);
      gfx_crater_framelist.setFramePool(&game_sprite_pool);
      gfx_crater_framelist.setFrameNumberAt(0, 137);
      // Prepare for spawning.
      gfx_spawn_framelist.allocFrameList(9);
      gfx_spawn_framelist.setFramePool(&game_sprite_pool);
      for (i=0 ; i<9 ; i++) {
	 gfx_spawn_framelist.setFrameNumberAt(i, 145+i);
      }
      // Also prepare for hitting objects..
      gfx_hit_framelist.setFramePool(&game_sprite_pool);
      gfx_hit_framelist.allocFrameList(8);
      for (i=0 ; i<8 ; i++) {
	 gfx_hit_framelist.setFrameNumberAt(i, 139+(i*6)/8);
      }
     
      gfx_red_tankfactory_framelist.setFramePool(&game_sprite_pool);
      gfx_red_tankfactory_framelist.allocFrameList(1); 
      gfx_red_tankfactory_framelist.setFrameNumberAt(0, 170);

      gfx_green_tankfactory_framelist.setFramePool(&game_sprite_pool);
      gfx_green_tankfactory_framelist.allocFrameList(1); 
      gfx_green_tankfactory_framelist.setFrameNumberAt(0, 171); 

      gfx_blue_tankfactory_framelist.setFramePool(&game_sprite_pool);
      gfx_blue_tankfactory_framelist.allocFrameList(1); 
      gfx_blue_tankfactory_framelist.setFrameNumberAt(0, 172);
 
      gfx_yellow_tankfactory_framelist.setFramePool(&game_sprite_pool);
      gfx_yellow_tankfactory_framelist.allocFrameList(1); 
      gfx_yellow_tankfactory_framelist.setFrameNumberAt(0, 173);
 
      // Do the same to the 'extras'.
      if (!gfx_unit_selector_framelists[0].allocFrameList(1)) 
	 ww_FATAL_ERROR("WWGameWindow::globalGraphicsInitialize() failed! Could not get memory for unit_selector_framelists\n");
      gfx_unit_selector_framelists[0].setFramePool(&game_extras_pool);
      gfx_unit_selector_framelists[0].setFrameNumberAt(0,0);
    
   }
//=======================================================================
// Randomize world map.
   void globalWorldMapInitialize( short width, short height, int seed ) {
      // yeah, randomize my arse...
      if (!loadBackgroundBitmap("inferno.bmp")) {
	 printf("Could not load inferno.bmp!\n");
      }     
      battle_field.setMapWidth(windowDrawSurface->width());
      battle_field.setMapHeight(windowDrawSurface->height());
   }
   
  
//================================================================

   void redrawUnitSelectorEnergyBar ( C_Unit *unit ) {
      QPainter p;
      short energy;
      
      if (unit) {	 
	 p.begin(gfx_unit_selector_framelists->getFrame(0));	
	 p.setPen(black);
	 p.drawRect(2,2,31,2);
	 p.setPen(green);
	 
	 energy = unit->hull();
	 if (energy < 50) p.setPen(yellow);
	 if (energy < 25) p.setPen(red);
      
	 int length = 1+(int)((float)30.0*energy/100.0);
	 if (length > 0) p.drawRect(2,2,length,2);
	 p.end();
      }
   }
//=================================================================

   C_Unit *selectTarget ( int mx, int my ) {
      C_Unit *unit;
      short mid_x, mid_y;
      short width, height;
      int wx, wy;
      viewportToContents(mx, my, wx, wy);
      unit = battle_field.firstExistingUnit();
      while (unit) {
	 // No suicides, thank you.
	 if (unit->ownerPlayerID() != thisPlayerID()) { 
	    unit->getBounds(width, height);
	    mid_x = (int)unit->worldX();
	    mid_y = (int)unit->worldY();
	 
	    if ((wx > (mid_x-(width >> 1))) && (wx < (mid_x+(width >> 1)))) {
	      if ((wy > (mid_y-(height >> 1))) && (wy < (mid_y+(height >> 1)))) 
		 return unit;
	    }	    	 
	 }
	 unit = unit->nextUnit();
      }                 
      return NULL;
   }
   // This differs from the routine above in that this should scan
   // only the units belonging to the user.
   C_Unit *selectUnit ( int mx, int my ) {
      C_Unit *unit;
      short mid_x, mid_y;
      short width, height;
      int wx, wy;

      viewportToContents(mx, my, wx, wy);
      
      unit = battle_field.firstExistingUnit();
      while (unit) {	 
	 if (unit->ownerPlayerID() == thisPlayerID()) {
	    unit->getBounds(width, height);
            mid_x = (int)unit->worldX();
            mid_y = (int)unit->worldY();
	 
            if ((wx > (mid_x-(width >> 1))) && (wx < (mid_x+(width >> 1)))) {
	      if ((wy > (mid_y-(height >> 1))) && (wy < (mid_y+(height >> 1)))) 
	         return unit;
	    }	    
	 }
	 unit = unit->nextUnit();
      }
      return NULL;     
   }

//====================================================================
// Handle player input.
    
   void viewportMouseReleaseEvent ( QMouseEvent *mouse_event ) {      
      C_Unit *unit;
      C_Sprite *sprite;
      int x0, y0, w, h;
      int view_x, view_y;
      int wx, wy;
      if (mouse_event->button() & LeftButton) {
	
//	 viewportToContents(mouse_event->x()-23, mouse_event->y()-23, wx, wy);	 
//	 ww_selectorSprite.paste(wx, wy, windowDrawSurface);
	 if (numUnitsSelected() == 0) {
	    if (!getSelectorBox(x0, y0, w, h)) {
	       // If left mouse button was clicked, try to figure out whether a unit
	       // was situated under the mouse cursor and select it if so.
	       // Scan through the list of units that this player has..
	       // viewportToContents(mouse_event->x(), mouse_event->y(), x, y);
	       unit = selectUnit(mouse_event->x(), mouse_event->y());
	       if (unit) {
		  if (!unit->isDisabled()) {
		     // Redraw the energy bar (this changes
		     // the appearance of the selector bitmap implicitly.)
		     sprite = new C_Sprite;	     
		     sprite->setFrameListArray(gfx_unit_selector_framelists);
		     sprite->setNumFrameLists(1);
		     sprite->setFrameList(0);
		 
		     unit->sprite()->attach(sprite);
		     redrawUnitSelectorEnergyBar(unit);
		     unit->select();
		     incrementNumUnitsSelected();
		     // handle comms
		     ww_comm_sendUnitSelectionMessage(unit->unitID(), FALSE);
		     ww_comm_sendUnitSelectionMessage(0, TRUE);
		  }
	       }
	    } else {
	       // Select all units within the
	       // unit selector box.
               unit = battle_field.firstExistingUnit();
	       while(unit) {
		  if (unit->ownerPlayerID() == thisPlayerID()) {
		     if (!unit->isDisabled()) {
			contentsToViewport((int)unit->worldX(), (int)unit->worldY(), view_x, view_y);
			if (w < 0) { x0 += w; w = abs(w); }
			if (h < 0) { y0 += h; h = abs(h); }
		     
			if ((view_x > x0) && (view_x < x0 + w)) {
			   if ((view_y > y0) && (view_y < y0 + h)) {
			      unit->select();
			      // Make a selector box sprite for each unit.
			      sprite = new C_Sprite;
			      sprite->setFrameListArray(gfx_unit_selector_framelists);
			      sprite->setNumFrameLists(1);
			      sprite->setFrameList(0);
			   
			      unit->sprite()->attach(sprite);
			      // Tell the outworld.
			      ww_comm_sendUnitSelectionMessage(unit->unitID(), FALSE);
			      // Increment units selected count
			      incrementNumUnitsSelected();
			   }
			}		   
		     }
		  }
		  unit = unit->nextUnit();
	       }
	       ww_comm_sendUnitSelectionMessage(0, TRUE);
	    }
         } else {
	    // If a unit is already selected interpret this event as 
	    // either a fire command or a move command.
            viewportToContents(mouse_event->x(), mouse_event->y(), wx, wy);	
            unit = selectTarget(mouse_event->x(), mouse_event->y());
            if (unit) {	     	       
	       // It's a fire command.
	       ww_comm_sendMousePositionMessage();
  	       ww_comm_sendFireCommand(wx, wy);
            
            } else {
	       // No, it's a move command.
	       ww_comm_sendMousePositionMessage();
	       ww_comm_sendMoveCommand(wx, wy);
	    }

         }
         destroySelectorBox();

      } else if (mouse_event->button() & RightButton) {
         // If right mouse button was pressed, release the currently selected
         // units. (just like in C&C)	
	 unit = battle_field.firstExistingUnit();	    
	 while(unit) {
	    if (unit->ownerPlayerID() == thisPlayerID())
	       if (unit->isSelected()) {
		  sprite = unit->sprite();
		  while(sprite->attachment())
		    sprite = sprite->attachment();
		  sprite->setDestroyWhenClean(TRUE);
		  
		  //sprite = unit->sprite()->detach();
		  //sprite->restoreBackground(windowDrawSurface);
		  //delete sprite;
	          unit->unselect();
	       }
	    //ww_selectedUnit->sprite()->restoreBackground(windowDrawSurface);
            //ww_selectedUnit->sprite()->detach();
	    //ww_selectedUnit->unselect();
	    //ww_selectedUnit = NULL;
	    
	    unit = unit->nextUnit();
	 }
         resetUnitsSelected();	 
      }       
   }

   int midbutton_pressed_at_x;
   int midbutton_pressed_at_y;
   int leftbutton_pressed_at_x;
   int leftbutton_pressed_at_y;

   int selbox_x0, selbox_y0;
   int selbox_width, selbox_height;
   void setSelectorBox ( int x, int y, int w, int h ) {
      selbox_x0 = x;
      selbox_y0 = y;
      selbox_width = w;
      selbox_height = h;
   }
   bool getSelectorBox ( int &x, int &y, int &w, int &h ) {
      x = selbox_x0; 
      y = selbox_y0;
      w = selbox_width;
      h = selbox_height;
      return (w != 0) & (h != 0) & (x != 0) & (y != 0);
   }
   void destroySelectorBox() {
      setSelectorBox(0, 0, 0, 0);
   }

   void viewportMousePressEvent ( QMouseEvent *mouse_event ) {
      if (mouse_event->button() & MidButton) {
	 midbutton_pressed_at_x = mouse_event->x();
	 midbutton_pressed_at_y = mouse_event->y();	 
      }
      if (mouse_event->button() & LeftButton) {
	 leftbutton_pressed_at_x = mouse_event->x();
	 leftbutton_pressed_at_y = mouse_event->y();
      }
   }
   void viewportMouseMoveEvent ( QMouseEvent *mouse_event ) {
  //    QPainter p(viewport());
      static char count=0;
      int mov_x, mov_y;
      int mx, my;
      // Update global mouse cursor position
      viewportToContents(mouse_event->x(), mouse_event->y(), mx, my);
      battle_field.setPlayerMouseXY(thisPlayerID(), mx, my);      
      // If the player has selected units let the world
      // know our mouse cursor location.
      if (numUnitsSelected() > 0) {
	 count %= 10;
	 if (count == 0)
	    ww_comm_sendMousePositionMessage();
	 count++;
      } else count = 0;
      
      // Let's use the middle button for scrolling.
      // Holding the left button down invokes the selector
      // box. 
      if (mouse_event->state() & MidButton) {
	 mov_x = mouse_event->x() - midbutton_pressed_at_x;
	 mov_y = mouse_event->y() - midbutton_pressed_at_y;
	 scrollBy(mov_x*2, mov_y*2);
	 
	 midbutton_pressed_at_x = mouse_event->x();
	 midbutton_pressed_at_y = mouse_event->y();
      }
      if (mouse_event->state() & LeftButton) {
         if (numUnitsSelected() == 0) {
	    mov_x = mouse_event->x() - leftbutton_pressed_at_x;
	    mov_y = mouse_event->y() - leftbutton_pressed_at_y;	
         
	    setSelectorBox(leftbutton_pressed_at_x, leftbutton_pressed_at_y,
			   mov_x, mov_y);
	 }
      }
   }
  
   // This routine redraws only what's visible on the window..
   // Faster.
   void updateAndRedrawVisibleWorldState() {
      // Backgrounds must be restored in reverse order they
      // were drawn to.
      C_Unit *unit, *next_unit;
      // C_UnitParam *typedata;     
      C_Sprite *sprite;
      short min_x, max_x;
      short min_y, max_y;
      short window_min_x = contentsX(), window_max_x = window_min_x + visibleWidth();
      short window_min_y = contentsY(), window_max_y = window_min_y + visibleHeight();  
      short w, h;      
 

      // Restore backgrounds in reverse order.
      // Do this regardless of visibility.
      detailSpriteList()->restoreBackground(windowDrawSurface);

      // This is to cure the problems
      // with asynchronously manipulated unit lists.  
      while ((sprite = iterateActiveSpritesReversed()) != NULL) {
	sprite->restoreBackground(windowDrawSurface);
      } 
      // Do some general management stuff like
      // seeing to that destroyed tanks actually get destroyed..
      unit = battle_field.firstExistingUnit();
      while(unit) {
	 next_unit = unit->nextUnit();
	 unit->handleStates();
	 unit = next_unit;
      }           
      unit = battle_field.firstExistingUnit();
      // Now, draw them sprites.
      while(unit) {	
	 // Save pointer to the next unit here. This is done here because
	 // this unit might cease to exist before we get to the bottom of this loop.
	 next_unit = unit->nextUnit();	 
	 // Check whether we need to draw this sucker. 
	 sprite = unit->sprite();
	 if (!unit->doNotDraw()) {

           unit->getBounds(w, h); 
	   min_x = (short)unit->worldX() - (w >> 1);
	   max_x = min_x + w;
	   min_y = (short)unit->worldY() - (h >> 1);
	   max_y = min_y + h;	

           markUnitInvisible(unit->unitID());  
	   // Draw if visible to the player
	   if ((max_x > window_min_x) && (min_x < window_max_x)) {
	     if ((max_y > window_min_y) && (min_y < window_max_y)) {	 
	       if ((unit->ownerPlayerID() == thisPlayerID()) && (unit->isSelected())) 
		 redrawUnitSelectorEnergyBar(unit);

	       unit->animateUnit();	
	       sprite->drawAt((short)unit->worldX(), (short)unit->worldY(), windowDrawSurface);
               markUnitVisible(unit->unitID());		 
	     }
	   }	    
	 } 
         addActiveSprite(sprite);
	 unit = next_unit;
      }
      //
      // Render 'detail' sprites on top of everything else.
      // NOTE: This is 'coding' in its purest form. 
      //
      C_Sprite *detail_s = detailSpriteList()->attachment();

      while(detail_s) {
        detail_s->frameBounds(w, h);
        // Interpret offsets as world-space coordinates
        // (i.e. offsets relative to the upper left corner of the map)
        min_x = detail_s->xOffset() - (w >> 1);    
	max_x = min_x + w;
	min_y = detail_s->yOffset() - (h >> 1);
	max_y = min_y + h;
	
	detail_s->setDontDraw(TRUE);  // Invisible
        if ((max_x > window_min_x) && (min_x < window_max_x)) {
	   if ((max_y > window_min_y) && (min_y < window_max_y)) {
	      detail_s->setDontDraw(FALSE);	
	   }
	}
	detail_s = detail_s->attachment();
      }
      detailSpriteList()->drawAt(0, 0, windowDrawSurface);
   }
//============================================================================

// Connect the build buttons to these
public slots:
   
   void buildTankButtonPressed() {
      if (gameInitComplete()) 
         ww_comm_sendBuildMessage(ww_TYPEID_TANK);
   }
   void buildTankFactoryButtonPressed() {
      if (gameInitComplete()) 
         ww_comm_sendBuildMessage(ww_TYPEID_TANK_FACTORY);
   }
   void panicButtonPressed() {
     if (QMessageBox::information(this, "WarWorld - Surrender?", 
                                  "Huh? Are you absolutely sure you want to surrender? But Sir..", 
                                  "Hell no! I'm a hellraiser!", "Yes, I'm yellow.") == 1) {
       ww_comm_sendQuitMessage();
       globalCommKill(); 
       exit(0);
     }   
   }
 
//============================================================================
protected:
  
    bool loadBackgroundBitmap ( char * p_file ) {
      bool result;
      if ((result = windowDrawSurface->load( QString(p_file) ))) {	
	 resizeContents(windowDrawSurface->width(), windowDrawSurface->height());
	 windowDrawSurface->setOptimization(QPixmap::NoOptim);
	 setCursor(crossCursor);	 
      } 
      return result;
   }
   
   void showLaunchDialog( bool f ) {
     static QSemiModal *dialog = NULL;
     static WWGameStatistics *stats;
     static QPushButton *the_big_red_button = NULL;
     if (f) {
       // create one if necessary..
       if (!dialog) {
	 dialog = new QSemiModal(this, 0, TRUE);
	 dialog->setCaption("WarWorld - Waiting for other players");
	 dialog->resize(400,400);
         dialog->setFixedSize(300,300);

         stats = new WWGameStatistics(dialog, battleField());
         stats->setGeometry(20,20, 260, 200);         
       }
       stats->updateStats();
       if (!the_big_red_button) {
	 the_big_red_button = new QPushButton(dialog);
	 the_big_red_button->setGeometry(50, 240, 200, 40);
         if (!thisPlayerIsHost()) the_big_red_button->setText("Launch!");
	 else the_big_red_button->setText("Launch When Ready, Sir!");
           
	 connect(the_big_red_button, SIGNAL(clicked()), this, SLOT(commConsentToLaunch()));
       }          
	 //}        
       dialog->show();
      
     } else {
       if (dialog) 
	 delete dialog;
      
       show();
     }
   }  

   

public:  
    WWGameEngine ( QWidget *parent=NULL ) : QScrollView(parent) {           
      windowDrawSurface = new C_DrawSurface;
     
      comm_inputBuffer = NULL;
      battle_field.setMapWidth(1024);
      battle_field.setMapHeight(1024);
      battle_field.setMapSeed(0);

      setCaption("WarWorld");      
      resetUnitsSelected();
      
      globalGraphicsInitialize();
      resetVisibilityInfo();     
      setFrameRate(20);    // 20 1/s
      resetGameTicks();
      
      globalWorldMapInitialize(battle_field.mapWidth(), battle_field.mapHeight(), battle_field.mapSeed());
      startTimer(1000/frameRate());     
 
      setGeometry(0,0, WW_DEFAULT_MAIN_WINDOW_WIDTH, WW_DEFAULT_MAIN_WINDOW_HEIGHT);
      setFixedSize(WW_DEFAULT_MAIN_WINDOW_WIDTH, WW_DEFAULT_MAIN_WINDOW_HEIGHT);     
      setMargins(0,0,180,0);
      setFocusPolicy(StrongFocus);      
      viewport()->setMouseTracking(TRUE);    

      game_statistics_window = new WWGameStatistics(this, &battle_field);
      game_statistics_window->setGeometry(width() - 190, 0, 170, 80);
      game_statistics_window->resizeContents(game_statistics_window->width(), game_statistics_window->height());
      game_statistics_window->setHScrollBarMode(AlwaysOff);
      
      QScrollView *controls = new QScrollView(this);
      controls->setGeometry(width() - 190, 100, 170, 280);
      controls->resizeContents(170, 280);
      controls->setHScrollBarMode(AlwaysOff);
      controls->setVScrollBarMode(AlwaysOn);
      
      QPushButton *buttons[10];     
      for (int j=0 ; j<5 ; j++) {
	 for (int i=0 ; i<2 ; i++) {
	    buttons[j*2+i] = new QPushButton(controls->viewport());
	    buttons[j*2+i]->setGeometry(i*75, j*280/5, 75, 280/5);	  
	 }
      }
      buttons[0]->setPixmap(QPixmap("btn_htank.bmp"));
      buttons[1]->setPixmap(QPixmap("btn_mammoth.bmp"));
      buttons[2]->setPixmap(QPixmap("btn_rifle.bmp"));
      QObject::connect(buttons[0], SIGNAL(clicked()), this, SLOT(buildTankButtonPressed()));

      // And now the most important button of all!
      // The Panic Button.
      QPushButton *panic_button = new QPushButton(this);
      panic_button->setText("Surrender");
      panic_button->setGeometry(width() - 150, height() - 80, 80, 40);
      QObject::connect(panic_button, SIGNAL(clicked()), this, SLOT(panicButtonPressed()));
      //showLaunchDialog();
 
      // show();      
   }
  
   QPixmap * drawSurface ( void ) {
      return windowDrawSurface;
   }
  
   void drawContents ( QPainter *, int, int, int, int) { return; };
   void paintEvent ( QPaintEvent * p ) { return; };
 
   void refreshViewport ( void ) {
      QPainter p(viewport());
      int x0, y0, w, h;
      
      updateAndRedrawVisibleWorldState();                    
      bitBlt(viewport(), 0, 0, drawSurface(), contentsX(), contentsY(), visibleWidth(), visibleHeight(), CopyROP, TRUE);

      if (getSelectorBox(x0, y0, w, h)) {
         p.setPen(white);
         p.drawRect(x0, y0, w, h);
      }     
   }
   void timerEvent ( QTimerEvent * te ) {            
      refreshViewport();     
      incrementGameTicks();
   }

};

void showColorDepthWarning() {
    QMessageBox::information(NULL, "WarWorld Client v0.0 - A Friendly Warning",
	        		   "Your current display settings may prove\n"
				   "unrealistic for running WarWorld.\n"
				   "   This application is designed for color\n"
				   "depths 15 and 16 bits per pixel.\n"
			           "   Higher color depths may induce\n"
			           "severe performance penalties while lower\n"
                                   "depths will sacrifice visual appearance.\n" 
			           "\nClick OK to continue.",
			           "OK");					 				      					       
}
// Separate IP and port information from addresses of the form:
// aaa.bbb.ccc.ddd:ppp.
void parseRawAddress ( char *addr ) {
  char ip[128];
  int separator_at = -1;
  int i;
  if (addr) {
    // Find the separating ':' if any.
    for (i=strlen(addr)-1 ; i>=0 ; i--) {
      if (addr[i] == ':') {
	separator_at = i;
	break;
      }
    }
    // Check whether a separator was found..
    if (separator_at == -1) {
      // Wasn't found. Interpret this address as IP-only.
      setServerAddress(addr);
    } else {
      // Oh yes, there it is.
      // Separate port number from the IP address.	    
      memcpy(ip, addr, separator_at);
      ip[separator_at] = '\0';
      setServerAddress(ip);
      setServerPort(atoi(&addr[separator_at+1]));
    }
  }
}
void parseCommandLine ( int argc, char *argv[] ) {
  char temp[128];
  bool ip_set = FALSE;
  printf("WarWorld Client version %i.%i initializing..\n", ww_VERSION_MAJOR, ww_VERSION_MINOR);            
  printf("Written by J. Argillander (japear@utu.fi)\n");
  for (int i=1; i<argc ; i++) {
    if (!strncmp(argv[i], "-ip=", 4)) {	    
      memset(temp, (int)'\0', sizeof(temp));
      strcpy(temp, (argv[i]+4));
      parseRawAddress(temp);
      //setServerAddress(temp);
      ip_set = TRUE;
    }
    if (!strncmp(argv[i], "-nick=",6)) {
      memset(temp, (int)'\0', sizeof(temp));
      strcpy(temp, (argv[i]+6));
      setThisPlayerNick(temp);
    }
  }
  if (argc == 1) {
    printf("----------------------------------------------\n");	
    printf("Parameters: -ip=aaa.bbb.ccc.ddd:pppp\n");
    printf("            -nick=your_nickname\n");
    printf("\nExample: -ip=127.0.0.1:8080 -nick=Maxwell\n");
    printf("         * game server at 127.0.0.1 port 8080\n");
    printf("         * enter game as Maxwell\n\n");
    printf("----------------------------------------------\n");
  }
  if (ip_set == FALSE) {
    printf("* No server address defined.\n");
  } else {
    printf("* Connecting to %s\n",serverAddress());
  }
}




bool showAddressRequestDialog( QWidget *p=NULL ) {     
  QDialog dialog(p, "Connect", TRUE);
  QPushButton *button;
  QLineEdit *editIP, *editNick;   
  QLabel *label;                      
            
  dialog.setCaption("WarWorld New Game");
  dialog.resize(300,200);
  dialog.setFixedSize(300,200);
      
  label = new QLabel(&dialog);
  label->setText("Server IP address (aaa.bbb.ccc.ddd:port)");
  label->setGeometry(20, 20, 300, 20);
  editIP = new QLineEdit(&dialog);
  editIP->setGeometry(20, 40, 180, 20);     
  editIP->setText("127.0.0.1:1025");
  editIP->selectAll();
  editIP->setEdited(TRUE);
      
  label = new QLabel(&dialog);
  label->setText("Your nickname (max 15 characters)");
  label->setGeometry(20, 80, 300, 20);
  editNick = new QLineEdit(&dialog);
  editNick->setGeometry(20, 100, 180, 20);
      
  button = new QPushButton(&dialog);
  button->setGeometry(20, 160, 100, 30);
  button->setText("Connect!");

  QObject::connect(button, SIGNAL(clicked()), &dialog, SLOT(accept()));
  
  button = new QPushButton(&dialog);
  button->setGeometry(210, 160, 70, 30);
  button->setText("Quit");
      
  QObject::connect(button, SIGNAL(clicked()), &dialog, SLOT(reject()));
  
  switch (dialog.exec()) {
  case QDialog::Accepted:	   
    if ((editIP->text().length() > 6) && (editNick->text().length() > 0)) {
      parseRawAddress(editIP->text());	    	   
      setThisPlayerNick(editNick->text());	       
      return TRUE;
    }
    break;
  case QDialog::Rejected:	 
    exit(0);
  }
  return FALSE;
}


  
// Yes, it's the ever-so-efficient main() function.
int main ( int argc, char *argv[] ) {
   char temp[256];          
      
   QApplication WWClient(argc, argv);
   WWGameEngine *gameEngine;

   gameEngine = new WWGameEngine;
   
   if ((QPixmap::defaultDepth() < 15) || (QPixmap::defaultDepth() > 16))
      showColorDepthWarning();

   // set defaults
   setServerAddress("127.0.0.1");
   setServerPort(1025);
   setThisPlayerNick("(Nobody)");

   parseCommandLine(argc, argv);

   QLabel *title = new QLabel(NULL);
   title->setCaption("WarWorld Client v0.0 (Experimental)");
   title->resize(400,400);
   title->setFixedSize(400,400);
   title->setPixmap(QPixmap("title1.bmp"));
   title->show();
   
   if (argc > 2) {
     if (!globalCommInitialize(gameEngine)) {
       printf("WWClient: Server at %s:%u did not respond.\n", serverAddress(), (unsigned short)(serverPort() << 8)|(serverPort() >> 8));
       exit(0);
     }
   } else {
     // If he didn't let's go for the widgets..
     while(1) {       
       while (!showAddressRequestDialog(NULL)) {
	 QMessageBox::warning(NULL, "Request", "Please enter the requested information.", "Retry");
       }
       if (globalCommInitialize(gameEngine))
	 break;
       
       sprintf(temp, "Server at %s:%u did not respond.", serverAddress(), (unsigned short)(serverPort() << 8)|(serverPort() >> 8));
       if (QMessageBox::warning(NULL, "WarWorld Client v0.0 - Failed!", temp, "Try again", "Quit") == 1) {
	 exit(0);
       }
     } 
   }
  
   sprintf(temp, "WarWorld: %s at %s:%u", thisPlayerNick(),serverAddress(),(unsigned short)(serverPort() << 8)|(serverPort() >> 8));
   gameEngine->setCaption(temp);
   WWClient.setMainWidget(gameEngine);
   
   ww_comm_sendPlayerData();
 
   return WWClient.exec();
}



