#ifndef __WWGAMESTATS_CC_INCLUDED__
#define __WWGAMESTATS_CC_INCLUDED__
//===================================================================
#define WW_DEFAULT_STATS_WINDOW_WIDTH  190
#define WW_DEFAULT_STATS_WINDOW_HEIGHT 400

class WWGameStatistics : public QScrollView {
 protected:
   C_BattleField *battle_zone;   
 public:
   WWGameStatistics ( QWidget * parent=0, C_BattleField *zone=NULL ) : QScrollView(parent) {
      viewport()->setBackgroundColor(QPainter::gray);
      setCaption("Kills / Losses");
      setGeometry(0,0, WW_DEFAULT_STATS_WINDOW_WIDTH, WW_DEFAULT_STATS_WINDOW_HEIGHT);
      resizeContents(width(), height());
      battle_zone = zone;
   }     
 protected:
   QColor convertPlayerColorToQColor ( int col ) {
      switch(col) {
       case 0: return (red);
       case 1: return (green);
       case 2: return (blue);
       case 3: return (yellow);
       case 4: return (gray);
      }
      return(red);
   }
 public:
   void drawContents ( QPainter * p, int cx, int cy, int cw, int ch ) {
      const short charHeight = 14;
      C_Player *player;
      char kills_str[64];      
      if (battle_zone) {
	 resizeContents(contentsWidth(),10+battle_zone->numPlayers()*charHeight);
         for (int i=0 ; i<battle_zone->numPlayers() ; i++) {
	    
	    player = battle_zone->player(i);
	    
	    sprintf(kills_str, "%i/%i", player->kills(), player->losses());
	    
	    p->setPen(convertPlayerColorToQColor(i));
	    p->drawText(5, 10+i*charHeight, QString(player->nickName()));
            p->drawText(contentsX() + visibleWidth() - 40, 10+i*charHeight, QString(kills_str));   	 
         }
      }
   }
   void updateStats() {
     repaintContents(contentsX(), contentsY(), visibleWidth(), visibleHeight(), TRUE);
   }
};

#endif


