#ifndef __WWPROTO_CC_INCLUDED__
#define __WWPROTO_CC_INCLUDED__
//==========================================
// WarWorld Protocol (as of 17/01/2000
// * Not very efficient now is it?
//
//==========================================
// Internal protocol version numbering
#define ww_proto_VERSION_MAJOR 0
#define ww_proto_VERSION_MINOR 0
// Client-2-Server messages:
// * Session initialization messages
#define ww_c_ENTER                "PLR"
#define ww_c_LAUNCH_GAME          "LCH"
#define ww_c_GAMEINIT_DONE        "RDY"
// * In-game messages
#define ww_c_MOUSE_POS            "AIM"
#define ww_c_SELECTED             "SEL"
#define ww_c_FIRE_COMMAND         "SHT"
#define ww_c_MOVE_COMMAND         "MOV"
#define ww_c_BUILD_COMMAND        "BLD"
// * Synchronization
#define ww_c_SYNCHRONIZE          "RDY"
// * Session termination
#define ww_c_QUIT                 "QIT"
//===========================================
// Server-2-Client messages:
// * Session initialization/termination
#define ww_s_PLAYER_INFO          "PLR"
#define ww_s_MAP_INFO             "MAP"
#define ww_s_GAMEINIT_DONE        "LCH"
#define ww_s_PLAYER_QUIT          "QIT"
// * In-game messages
#define ww_s_CLIENT_RESET         "INI"
#define ww_s_END_OF_DATA          "END"
#define ww_s_MOUSE_POS            "AIM"
#define ww_s_SELECTED             "SEL"
#define ww_s_FIRE_COMMAND         "SHT"
#define ww_s_UNIT_HIT             "HIT"                    
//#define ww_s_DESTROYED            "DSY"
#define ww_s_UNIT_POSITION        "POS"
#define ww_s_WAYPOINT             "WPT"
#define ww_s_NEW_UNIT             "NEW"
#define ww_s_RESOURCES            "RES"
#define ww_s_SCORE                "SCR"
#define ww_s_ERROR                "ERR"
//============================================
// * Define 'command IDs'
// In-game server-2-client
enum {
   ww_s_IS_CLIENT_RESET  = 0,
   ww_s_IS_END_OF_DATA   = 1,
   ww_s_IS_MOUSE_POS     = 2,
   ww_s_IS_SELECTED      = 3,
   ww_s_IS_FIRE_COMMAND  = 4,
   ww_s_IS_UNIT_POSITION = 5,
   ww_s_IS_WAYPOINT      = 6,
   ww_s_IS_NEW_UNIT      = 7,
   /*ww_s_IS_DESTROYED     = 8,*/
   ww_s_IS_HIT           = 9,

   ww_s_IS_PLAYER_INFO   = 10,
   ww_s_IS_MAP_INFO      = 11,
   ww_s_IS_INIT_DONE     = 12,
   ww_s_IS_VERSION       = 13,
   ww_s_IS_PLAYER_QUIT   = 14,
   ww_s_IS_RESOURCES     = 15,
   ww_s_IS_SCORE         = 16,
   ww_s_IS_ERROR         = 17,
   ww_s_IS_INVALID       = 0xFFFF
};
int ww_s_GetInGameCommandID ( char *msg ) {   
   if (msg) {
      switch(msg[0]) {
	// In-game messages
      case 'A': return ww_s_IS_MOUSE_POS;
      case 'P': 
	if (msg[1] == 'L') return ww_s_IS_PLAYER_INFO;
	return ww_s_IS_UNIT_POSITION;
      case 'I': return ww_s_IS_CLIENT_RESET;
      case 'N': return ww_s_IS_NEW_UNIT;
	//case 'U': return ww_s_IS_UNIT_POSITION;	 
      case 'S':
	if (msg[1] == 'E') return ww_s_IS_SELECTED;
        if (msg[1] == 'C') return ww_s_IS_SCORE;
	return ww_s_IS_FIRE_COMMAND;
      case 'W': return ww_s_IS_WAYPOINT;
      case 'H': return ww_s_IS_HIT;
	//case 'D': return ww_s_IS_DESTROYED;
      case 'R': return ww_s_IS_RESOURCES;
	// Session initialization-related stuff
      case 'M': return ww_s_IS_MAP_INFO;
      case 'L': return ww_s_IS_INIT_DONE;
      case 'V': return ww_s_IS_VERSION;
      case 'Q': return ww_s_IS_PLAYER_QUIT;
	// Error message
      case 'E': 
         if (msg[1] == 'R') return ww_s_IS_ERROR;
         return ww_s_IS_END_OF_DATA;
      }
   }
   return ww_s_IS_INVALID;
}

#endif





