#ifndef __WWSPRITEDEFS_CC_INCLUDED__
#define __WWSPRITEDEFS_CC_INCLUDED__

class WWTankSprite : public C_Sprite {
 public:
   WWTankSprite( short owner_id ) {
      C_FrameList *tank_player_id_2_framelists[4][2] = {
	 {gfx_red_tank_base_framelists,    gfx_red_tank_barrel_framelists},
	 {gfx_green_tank_base_framelists,  gfx_green_tank_barrel_framelists},
 	 {gfx_blue_tank_base_framelists,   gfx_blue_tank_barrel_framelists},
	 {gfx_yellow_tank_base_framelists, gfx_yellow_tank_barrel_framelists}
      };

      C_Sprite *temp;
      setFrameListArray(tank_player_id_2_framelists[owner_id][0]);
      setNumFrameLists(16);
      setFrameList(0);
      setFrame(0);
      optimizeBackgroundBufferSize();
      
      temp = new C_Sprite;
      temp->setFrameListArray(tank_player_id_2_framelists[owner_id][1]);
      temp->setNumFrameLists(16);
      temp->setFrameList(rand()%16);
      temp->setFrame(0);
      temp->setDontSaveBackground(TRUE);
      
      attach(temp);     
   }   
};

class WWTankFactorySprite : public C_Sprite {
public:
  WWTankFactorySprite ( short owner_id ) {
    C_FrameList *player_id_2_framelist[4] = {
      &gfx_red_tankfactory_framelist, 
      &gfx_green_tankfactory_framelist,
      &gfx_blue_tankfactory_framelist, 
      &gfx_yellow_tankfactory_framelist
    }; 
    
    setFrameListArray(player_id_2_framelist[owner_id]);
    setNumFrameLists(1);
    setFrameList(0); 
    setFrame(0); 
    optimizeBackgroundBufferSize();
    //setDrawOnce(TRUE);
  }
};

class WWExplosionSprite : public C_Sprite {
 public:
   WWExplosionSprite() {
      setFrameListArray(&gfx_explosion_framelist);
      setNumFrameLists(1);
      setFrameList(0);
      setFrame(0);	     
      setAutoAnimation(TRUE);
      setDestroyAfterLastFrame(TRUE);
      optimizeBackgroundBufferSize();
   }
};

class WWSpawnSprite : public C_Sprite {
 public:
   WWSpawnSprite() {
      setFrameListArray(&gfx_spawn_framelist);
      setNumFrameLists(1);
      setFrame(0);
      setAutoAnimation(TRUE);
      setDestroyAfterLastFrame(TRUE);
      optimizeBackgroundBufferSize();
   }
};

 
class WWHitSprite : public C_Sprite {
public:
   WWHitSprite() {
      setFrameListArray(&gfx_hit_framelist);
      setNumFrameLists(1);
      setFrame(0);
      optimizeBackgroundBufferSize();     
      setAutoAnimation(TRUE);
      setDestroyAfterLastFrame(TRUE);
   }
};

class WWCraterSprite : public C_Sprite {
 public:
   WWCraterSprite() {
            
   }
};

class WWFlameSprite : public C_Sprite {
 public:
   WWFlameSprite() {
      setFrameListArray(gfx_flame_framelists);
      setNumFrameLists(16);
      setFrameList(0);
      setFrame(0);
      optimizeBackgroundBufferSize();      
      setAutoAnimation(TRUE);
      setDestroyAfterLastFrame(TRUE);	  
   }
};

#endif



